/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.grabrule.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.grabrule.service.IKmsGrabRuleService;
import com.biz.crm.grabrule.service.IKmsRequestService;
import com.biz.crm.nebular.kms.grabrule.req.KmsGrabRuleReqVo;
import com.biz.crm.nebular.kms.grabrule.resp.KmsGrabRuleRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/kmsgrabrule"})
@Api(tags={"\u6293\u5355\u89c4\u5219\u914d\u7f6e\u8868"})
public class KmsGrabRuleController {
    private static final Logger log = LoggerFactory.getLogger(KmsGrabRuleController.class);
    @Autowired
    private IKmsGrabRuleService kmsGrabRuleService;
    @Resource
    private IKmsRequestService kmsRequestService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    public Result<PageResult<KmsGrabRuleRespVo>> list(@RequestBody KmsGrabRuleReqVo kmsGrabRuleReqVo) {
        PageResult<KmsGrabRuleRespVo> result = this.kmsGrabRuleService.findList(kmsGrabRuleReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @PostMapping(value={"/query"})
    @CrmLog
    public Result<KmsGrabRuleRespVo> query(@RequestBody KmsGrabRuleReqVo kmsGrabRuleReqVo) {
        KmsGrabRuleRespVo respVo = this.kmsGrabRuleService.query(kmsGrabRuleReqVo);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody KmsGrabRuleReqVo kmsGrabRuleReqVo) {
        if (StringUtils.isEmpty((String)kmsGrabRuleReqVo.getId())) {
            this.kmsGrabRuleService.save(kmsGrabRuleReqVo);
        } else {
            this.kmsGrabRuleService.update(kmsGrabRuleReqVo);
        }
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody KmsGrabRuleReqVo kmsGrabRuleReqVo) {
        this.kmsGrabRuleService.update(kmsGrabRuleReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        this.kmsGrabRuleService.deleteBatch(new KmsGrabRuleReqVo().setIds(ids));
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        this.kmsGrabRuleService.enableBatch(new KmsGrabRuleReqVo().setIds(ids));
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        this.kmsGrabRuleService.disableBatch(new KmsGrabRuleReqVo().setIds(ids));
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u624b\u52a8\u6293\u5355")
    @PostMapping(value={"/manualGrab"})
    @CrmLog
    public Result manualGrab(@RequestBody KmsGrabRuleReqVo reqVo) {
        this.kmsRequestService.manualGrab(reqVo);
        return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
    }
}

