/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.grabrule.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.config.KmsConfig;
import com.biz.crm.core.xxllog.XxlJobLogger;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.kms.KmsAdminEnum;
import com.biz.crm.grabrule.helper.KmsGrabRuleHelper;
import com.biz.crm.grabrule.helper.KmsRequestHelper;
import com.biz.crm.grabrule.mapper.KmsDataAuthMapper;
import com.biz.crm.grabrule.mapper.KmsGrabRuleMapper;
import com.biz.crm.grabrule.mapper.KmsLoggerDataProcessMapper;
import com.biz.crm.grabrule.mapper.KmsRequestMapper;
import com.biz.crm.grabrule.model.KmsDataAuthEntity;
import com.biz.crm.grabrule.model.KmsLoggerDataProcessEntity;
import com.biz.crm.grabrule.model.KmsRequestEntity;
import com.biz.crm.grabrule.service.IKmsRequestService;
import com.biz.crm.nebular.kms.grabrule.req.KmsGrabRuleReqVo;
import com.biz.crm.nebular.kms.grabrule.resp.KmsGrabRuleRespVo;
import com.biz.crm.supermarket.mapper.KmsTenantryDirectAccountMapper;
import com.biz.crm.supermarket.mapper.KmsTenantryDirectStoreMapper;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.UserUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
@ConditionalOnMissingBean(name={"KmsRequestServiceImpl"})
public class KmsRequestServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<KmsRequestMapper, KmsRequestEntity>
implements IKmsRequestService {
    private static final Logger log = LoggerFactory.getLogger(KmsRequestServiceImpl.class);
    @Resource
    private KmsGrabRuleMapper kmsGrabRuleMapper;
    @Resource
    private KmsTenantryDirectAccountMapper kmsAccountMapper;
    @Resource
    private KmsTenantryDirectStoreMapper kmsTenantryDirectStoreMapper;
    @Resource
    private KmsRequestHelper kmsRequestHelper;
    @Resource
    private KmsDataAuthMapper kmsDataAuthMapper;
    @Resource
    private KmsGrabRuleHelper kmsGrabRuleHelper;
    @Resource
    private KmsConfig kmsConfig;
    @Resource
    private KmsLoggerDataProcessMapper kmsLoggerDataProcessMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(String grabId) {
        log.info("\u6293\u5355\u8bf7\u6c42\u53c2\u6570\u6293\u5355\u89c4\u5219ID\uff1a{}", (Object)grabId);
        KmsAdminEnum.AutoType auto = KmsAdminEnum.AutoType.AUTO;
        KmsGrabRuleReqVo param = new KmsGrabRuleReqVo();
        param.setId(grabId);
        param.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        KmsGrabRuleRespVo grabRuleRespVo = this.kmsGrabRuleMapper.findById(param);
        if (ObjectUtils.isEmpty((Object)grabRuleRespVo)) {
            return;
        }
        String trackId = String.join((CharSequence)"<=>", auto.getDescription(), this.kmsConfig.getTenantryId(), grabRuleRespVo.getRuleName(), DateTimeFormatter.ofPattern("yyyyMMddHHmmss").format(LocalDateTime.now()));
        String rawDataId = UUID.randomUUID().toString().replaceAll("-", "");
        grabRuleRespVo.setRawDataId(rawDataId);
        String grabRuleEntityId = grabRuleRespVo.getId();
        JSONObject reqParm = this.kmsRequestHelper.buildReqPams(grabRuleEntityId);
        this.kmsRequestHelper.buildReqPamStore(reqParm, grabRuleEntityId, grabRuleRespVo.getIsAllStore());
        this.kmsRequestHelper.buildCommonReqPams(reqParm, grabRuleRespVo);
        JSONObject extendParm = this.kmsRequestHelper.buildExtendParms(grabRuleRespVo, trackId, auto);
        JSONObject request = this.kmsRequestHelper.buildRequest(reqParm, extendParm);
        KmsRequestEntity entity = this.kmsRequestHelper.buildRequestEntity(grabRuleRespVo, request, auto);
        this.save(entity);
        KmsDataAuthEntity authEntity = this.kmsRequestHelper.buildAuthEntity(grabRuleRespVo);
        this.kmsDataAuthMapper.insert(authEntity);
        KmsLoggerDataProcessEntity loggerEntity = this.kmsRequestHelper.buildLogger(grabRuleRespVo, auto);
        loggerEntity.setRequest(entity.getRequest());
        this.kmsLoggerDataProcessMapper.insert(loggerEntity);
        XxlJobLogger.log((String)"\u6293\u5355\u8bf7\u6c42\u5df2\u7ecf\u4fdd\u5b58\u5230\u6570\u636e\u5e93\u4e2d\uff0c\u65f6\u95f4\uff1a[{}]\u8ffd\u8e2aID\uff1a[{}]", (Object[])new Object[]{DateTimeFormatter.ofPattern("yyyyMMddHHmmss").format(LocalDateTime.now()), trackId});
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void manualGrab(KmsGrabRuleReqVo reqVo) {
        KmsAdminEnum.AutoType manual = KmsAdminEnum.AutoType.MANUAL;
        this.kmsGrabRuleHelper.check(reqVo);
        KmsGrabRuleRespVo grabRuleRespVo = (KmsGrabRuleRespVo)CrmBeanUtil.copy((Object)reqVo, KmsGrabRuleRespVo.class);
        String trackId = String.join((CharSequence)"<=>", manual.getDescription(), this.kmsConfig.getTenantryId(), grabRuleRespVo.getRuleName(), DateTimeFormatter.ofPattern("yyyyMMddHHmmss").format(LocalDateTime.now()));
        String rawDataId = UUID.randomUUID().toString().replaceAll("-", "");
        grabRuleRespVo.setRawDataId(rawDataId);
        grabRuleRespVo.setNickName(UserUtils.getUser().getRealname());
        String grabRuleEntityId = grabRuleRespVo.getId();
        JSONObject reqParm = this.kmsRequestHelper.buildManualGrabReqPams(reqVo);
        this.kmsRequestHelper.buildReqPamStore(reqParm, grabRuleEntityId, grabRuleRespVo.getIsAllStore());
        this.kmsRequestHelper.buildCommonReqPams(reqParm, grabRuleRespVo);
        JSONObject extendParm = this.kmsRequestHelper.buildExtendParms(grabRuleRespVo, trackId, manual);
        JSONObject request = this.kmsRequestHelper.buildRequest(reqParm, extendParm);
        KmsRequestEntity entity = this.kmsRequestHelper.buildRequestEntity(grabRuleRespVo, request, manual);
        this.save(entity);
        KmsDataAuthEntity authEntity = this.kmsRequestHelper.buildAuthEntity(grabRuleRespVo);
        this.kmsDataAuthMapper.insert(authEntity);
        KmsLoggerDataProcessEntity loggerEntity = this.kmsRequestHelper.buildLogger(grabRuleRespVo, manual);
        loggerEntity.setRequest(entity.getRequest());
        this.kmsLoggerDataProcessMapper.insert(loggerEntity);
    }
}

