/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.orderform.helper;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.kms.KmsAdminEnum;
import com.biz.crm.eunm.kms.KmsEnum;
import com.biz.crm.grabrule.mapper.KmsDataAuthMapper;
import com.biz.crm.nebular.kms.rawdata.resp.KmsOrderFormDetailDwRespVo;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.orderform.mapper.KmsOrderFormMapper;
import com.biz.crm.orderform.mapper.KmsOrderGoodsMapper;
import com.biz.crm.orderform.model.KmsOrderFormEntity;
import com.biz.crm.orderform.model.KmsOrderGoodsEntity;
import com.biz.crm.rawdata.model.KmsOrderFormDetailDwEntity;
import com.biz.crm.rawdata.model.KmsOrderGoodsDetailDwEntity;
import com.biz.crm.rawdata.service.IKmsOrderFormDetailDwService;
import com.biz.crm.rawdata.service.IKmsOrderGoodsDetailDwService;
import com.biz.crm.trans.service.IKmsTransDataService;
import com.biz.crm.trans.vo.TransDataGoodsVo;
import com.biz.crm.trans.vo.TransDataStoreVo;
import com.biz.crm.trans.vo.TransDataVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.KmsUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Component
public class KmsOrderFormHelper {
    private static final Logger log = LoggerFactory.getLogger(KmsOrderFormHelper.class);
    @Resource
    private KmsOrderFormMapper kmsOrderFormMapper;
    @Resource
    private KmsOrderGoodsMapper kmsOrderGoodsMapper;
    @Resource
    private IKmsOrderFormDetailDwService kmsOrderFormDetailDwService;
    @Resource
    private IKmsOrderGoodsDetailDwService kmsOrderGoodsDetailDwService;
    @Resource
    private IKmsTransDataService kmsTransDataService;
    @Resource
    private KmsDataAuthMapper kmsDataAuthMapper;

    public KmsOrderFormEntity transFormVersion(KmsOrderFormDetailDwRespVo dwRespVo) {
        String orderNumber = dwRespVo.getOrderNumber();
        List orderDwEntities = ((LambdaQueryChainWrapper)this.kmsOrderFormDetailDwService.lambdaQuery().eq(KmsOrderFormDetailDwEntity::getOrderNumber, (Object)orderNumber)).list();
        KmsOrderFormDetailDwEntity dwEntity = orderDwEntities.stream().sorted(Comparator.comparing(KmsOrderFormDetailDwEntity::getVersionNumber).reversed()).findFirst().orElse(null);
        LambdaQueryWrapper build = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(KmsOrderFormEntity::getOrderNumber, (Object)orderNumber);
        KmsOrderFormEntity orderFormEntity = (KmsOrderFormEntity)this.kmsOrderFormMapper.selectOne((Wrapper)build);
        if (ObjectUtils.isEmpty((Object)orderFormEntity)) {
            orderFormEntity = (KmsOrderFormEntity)CrmBeanUtil.copy((Object)dwEntity, KmsOrderFormEntity.class);
            orderFormEntity.setBsDirectSystemId(dwRespVo.getBsDirectSystemId());
            orderFormEntity.setCreateCode(dwRespVo.getCreateCode());
            orderFormEntity.setCreateName(dwRespVo.getCreateName());
            orderFormEntity.setCreateOrgCode(dwRespVo.getCreateOrgCode());
            orderFormEntity.setCreateOrgName(dwRespVo.getCreateOrgName());
            orderFormEntity.setCreatePosCode(dwRespVo.getCreatePosCode());
            orderFormEntity.setCreatePosName(dwRespVo.getCreatePosName());
        } else if (!YesNoEnum.yesNoEnum.no.getValue().equals(orderFormEntity.getIsTrans())) {
            BeanUtils.copyProperties((Object)dwEntity, (Object)orderFormEntity, (String[])KmsUtils.ignoreProperties());
            orderFormEntity.setRemarks(dwEntity.getRemarks());
        }
        orderDwEntities.forEach(dw -> dw.setTransStatus(YesNoEnum.yesNoEnum.ONE.getValue()));
        this.kmsOrderFormDetailDwService.updateBatchById(orderDwEntities);
        return orderFormEntity;
    }

    public List<KmsOrderGoodsEntity> transGoodsVersion(KmsOrderFormEntity orderFormEntity) {
        String orderNumber = orderFormEntity.getOrderNumber();
        Integer versionNumber = orderFormEntity.getVersionNumber();
        LambdaUpdateWrapper wrapper = (LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(KmsOrderGoodsEntity::getOrderNumber, (Object)orderNumber);
        List deleteOrderGoodsEntities = this.kmsOrderGoodsMapper.selectList((Wrapper)wrapper);
        Map goodsMap = deleteOrderGoodsEntities.stream().collect(Collectors.toMap(o -> o.getOrderNumber() + "-" + o.getVersionNumber() + "-" + o.getKaGoodsCode(), Function.identity()));
        List detailDwEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.kmsOrderGoodsDetailDwService.lambdaQuery().eq(KmsOrderGoodsDetailDwEntity::getOrderNumber, (Object)orderNumber)).eq(KmsOrderGoodsDetailDwEntity::getVersionNumber, (Object)versionNumber)).list();
        Map dwEntityMap = detailDwEntities.stream().collect(Collectors.toMap(o -> o.getOrderNumber() + "-" + o.getVersionNumber() + "-" + o.getKaGoodsCode(), Function.identity(), (v1, v2) -> v1));
        HashMap onlyMap = Maps.newHashMap();
        detailDwEntities.forEach(o -> {
            KmsOrderGoodsEntity goodsEntity;
            String key = o.getOrderNumber() + "-" + o.getVersionNumber() + "-" + o.getKaGoodsCode();
            goodsEntity.setOrderAmount(StringUtils.isEmpty((Object)(goodsEntity = (KmsOrderGoodsEntity)CrmBeanUtil.copy((Object)o, KmsOrderGoodsEntity.class)).getOrderAmount()) ? "0" : goodsEntity.getOrderAmount());
            goodsEntity.setOrderAmountNot(StringUtils.isEmpty((Object)goodsEntity.getOrderAmountNot()) ? "0" : goodsEntity.getOrderAmountNot());
            goodsEntity.setCurUnitOrderQuantity(StringUtils.isEmpty((Object)goodsEntity.getCurUnitOrderQuantity()) ? "0" : goodsEntity.getCurUnitOrderQuantity());
            goodsEntity.setRemarks(o.getRemarks());
            if (!ObjectUtils.isEmpty(onlyMap.get(key))) {
                KmsOrderGoodsEntity en = (KmsOrderGoodsEntity)onlyMap.get(key);
                en.setOrderAmount(new BigDecimal(en.getOrderAmount()).add(new BigDecimal(goodsEntity.getOrderAmount())).toString());
                en.setOrderAmountNot(new BigDecimal(en.getOrderAmountNot()).add(new BigDecimal(goodsEntity.getOrderAmountNot())).toString());
                en.setCurUnitOrderQuantity(new BigDecimal(en.getCurUnitOrderQuantity()).add(new BigDecimal(goodsEntity.getCurUnitOrderQuantity())).toString());
                onlyMap.put(key, en);
            } else {
                KmsOrderGoodsEntity entity = ObjectUtils.isEmpty(goodsMap.get(key)) ? new KmsOrderGoodsEntity() : (KmsOrderGoodsEntity)goodsMap.get(key);
                BeanUtils.copyProperties((Object)goodsEntity, (Object)entity, (String[])KmsUtils.ignoreProperties());
                onlyMap.put(key, entity);
            }
        });
        ArrayList goodsIds = Lists.newArrayList();
        goodsMap.forEach((k, v) -> {
            if (ObjectUtils.isEmpty(dwEntityMap.get(k))) {
                goodsIds.add(v.getId());
            }
        });
        if (!CollectionUtils.isEmpty((Collection)goodsIds)) {
            this.kmsOrderGoodsMapper.deleteBatchIds(goodsIds);
        }
        ArrayList onlyList = Lists.newArrayList();
        onlyMap.forEach((k, v) -> onlyList.add(v));
        return onlyList;
    }

    public void transData(KmsOrderFormEntity orderFormEntity, List<KmsOrderGoodsEntity> goodsEntities) {
        TransDataVo transDataVo = new TransDataVo();
        transDataVo.setOrderType(KmsAdminEnum.OrderType.ORDER.getValue());
        orderFormEntity.setOrderStatusMsg("");
        TransDataStoreVo dataStoreVo = (TransDataStoreVo)((Object)CrmBeanUtil.copy((Object)orderFormEntity, TransDataStoreVo.class));
        dataStoreVo.setSoldToPartyCode(null);
        dataStoreVo.setSoldToPartyName(null);
        dataStoreVo.setKaOrderNumber(orderFormEntity.getKaOrderNumber());
        dataStoreVo.setOrderStatusMsg("");
        dataStoreVo.setKaName(orderFormEntity.getKaName());
        transDataVo.setStoreVos(dataStoreVo);
        if (!StringUtils.isEmpty((Object)orderFormEntity.getCustomerOrgCode())) {
            Map dateMap = DictUtil.dictMap((String)"kms_order_week_product_date");
            Calendar cl = Calendar.getInstance();
            String day = (String)dateMap.get(orderFormEntity.getCustomerOrgCode());
            AssertUtils.isNotEmpty((String)day, (String)"\u8bf7\u914d\u7f6e\u661f\u671f\u7269\u6599\u8f6c\u6362\u65f6\u95f4\u9608\u503c");
            int dayInt = Integer.parseInt(day);
            cl.add(5, dayInt);
            transDataVo.setOrderDate(DateUtil.format((Date)cl.getTime(), (String)"yyyy-MM-dd"));
        } else {
            transDataVo.setOrderDate(orderFormEntity.getOrderDate());
        }
        HashMap goodsEntityMap = Maps.newHashMap();
        goodsEntities.forEach(o -> {
            List entities = (List)goodsEntityMap.get(o.getOrderNumber());
            if (CollectionUtils.isEmpty((Collection)entities)) {
                entities = Lists.newArrayList();
            }
            entities.add(o);
            goodsEntityMap.put(o.getOrderNumber(), entities);
            TransDataGoodsVo dataGoodsVo = (TransDataGoodsVo)((Object)((Object)CrmBeanUtil.copy((Object)o, TransDataGoodsVo.class)));
            dataGoodsVo.setCurUnitOrderQuantity(o.getCurUnitOrderQuantity());
            dataGoodsVo.setKaOrderNumber(o.getKaOrderNumber());
            dataGoodsVo.setOrderStatusMsg("");
            dataGoodsVo.setKaName(o.getKaName());
            dataGoodsVo.setOrderDate(transDataVo.getOrderDate());
            transDataVo.getGoodsVos().add(dataGoodsVo);
        });
        this.kmsTransDataService.transData(transDataVo);
        this.resultProcessing(orderFormEntity, goodsEntities, transDataVo);
    }

    private void resultProcessing(KmsOrderFormEntity orderFormEntity, List<KmsOrderGoodsEntity> goodsEntities, TransDataVo transDataVo) {
        String orderNumber = orderFormEntity.getOrderNumber();
        TransDataStoreVo transDataStoreVo = transDataVo.getStoreVos();
        BeanUtils.copyProperties((Object)((Object)transDataStoreVo), (Object)orderFormEntity, (String[])Arrays.stream(CrmBaseVo.class.getDeclaredFields()).map(Field::getName).collect(Collectors.toList()).toArray(new String[0]));
        Map dataGoodsVoMap = transDataVo.getGoodsVos().stream().collect(Collectors.toMap(TransDataGoodsVo::getKaGoodsCode, Function.identity()));
        goodsEntities.forEach(goods -> {
            String kaGoodsCode = goods.getKaGoodsCode();
            TransDataGoodsVo transDataGoodsVo = (TransDataGoodsVo)((Object)((Object)dataGoodsVoMap.get(kaGoodsCode)));
            BeanUtils.copyProperties((Object)((Object)transDataGoodsVo), (Object)goods, (String[])Arrays.stream(CrmBaseVo.class.getDeclaredFields()).map(Field::getName).collect(Collectors.toList()).toArray(new String[0]));
            if (!StringUtils.isEmpty((Object)goods.getOrderStatusMsg())) {
                goods.setOrderStatus(KmsEnum.OrderStatus.S100.getValue());
            } else {
                goods.setOrderStatus(KmsEnum.OrderStatus.S400.getValue());
                goods.setOrderStatusMsg("\u8f6c\u6362\u6210\u529f");
            }
        });
        String orderStatusMsg = orderFormEntity.getOrderStatusMsg();
        List errorList = goodsEntities.stream().filter(goods -> KmsEnum.OrderStatus.S100.getValue().equals(goods.getOrderStatus())).collect(Collectors.toList());
        if (!StringUtils.isEmpty((Object)orderStatusMsg) || !CollectionUtils.isEmpty(errorList)) {
            orderFormEntity.setOrderStatus(KmsEnum.OrderStatus.S100.getValue());
            if (!CollectionUtils.isEmpty(errorList) && !StringUtils.isEmpty((Object)orderStatusMsg)) {
                orderFormEntity.setOrderStatusMsg(orderStatusMsg + "|\u5546\u54c1\u884c\u4fe1\u606f\u5b58\u5728\u8f6c\u6362\u5931\u8d25\u6570\u636e");
            } else if (!CollectionUtils.isEmpty(errorList) && StringUtils.isEmpty((Object)orderStatusMsg)) {
                orderFormEntity.setOrderStatusMsg("\u5546\u54c1\u884c\u4fe1\u606f\u5b58\u5728\u8f6c\u6362\u5931\u8d25\u6570\u636e");
            }
        } else {
            orderFormEntity.setOrderStatus(KmsEnum.OrderStatus.S400.getValue());
        }
        if (StringUtils.isEmpty((Object)orderFormEntity.getOrderStatusMsg())) {
            orderFormEntity.setOrderStatusMsg("\u8f6c\u6362\u6210\u529f");
        }
    }
}

