/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.orderform.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.kms.orderform.req.KmsOrderFormReqVo;
import com.biz.crm.nebular.kms.orderform.resp.KmsOrderFormExportRespVo;
import com.biz.crm.nebular.kms.orderform.resp.KmsOrderFormRespVo;
import com.biz.crm.nebular.kms.orderform.resp.KmsOrderGoodsRespVo;
import com.biz.crm.nebular.kms.rawdata.resp.KmsOrderFormDetailDwRespVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsTenantryDirectCustomerOrgRespVo;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.orderform.helper.KmsOrderFormHelper;
import com.biz.crm.orderform.mapper.KmsOrderFormMapper;
import com.biz.crm.orderform.model.KmsOrderFormEntity;
import com.biz.crm.orderform.model.KmsOrderGoodsEntity;
import com.biz.crm.orderform.service.IKmsOrderFormService;
import com.biz.crm.orderform.service.IKmsOrderGoodsService;
import com.biz.crm.orderform.service.IKmsOrderStatusRecordService;
import com.biz.crm.sap.helper.KmsSapHelper;
import com.biz.crm.supermarket.service.IKmsTenantryDirectCustomerOrgService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.KmsOrgUtil;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.xml.soap.SOAPException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.cxf.interceptor.Fault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
@ConditionalOnMissingBean(name={"KmsOrderFormServiceExpandImpl"})
public class KmsOrderFormServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<KmsOrderFormMapper, KmsOrderFormEntity>
implements IKmsOrderFormService {
    private static final Logger log = LoggerFactory.getLogger(KmsOrderFormServiceImpl.class);
    @Resource
    private KmsOrderFormMapper kmsOrderFormMapper;
    @Resource
    private IKmsOrderGoodsService kmsOrderGoodsService;
    @Resource
    private KmsOrderFormHelper kmsOrderFormHelper;
    @Resource
    private IKmsOrderStatusRecordService kmsOrderStatusRecordService;
    @Resource
    private KmsSapHelper kmsSapHelper;
    @Resource
    private IKmsTenantryDirectCustomerOrgService kmsTenantryDirectCustomerOrgService;

    @Override
    public PageResult<KmsOrderFormRespVo> findList(KmsOrderFormReqVo reqVo) {
        Page page;
        List<KmsOrderFormRespVo> list;
        if (StringUtils.isNotEmpty((String)reqVo.getCompanyOrgCode())) {
            List childrenOrgListIncludeSelf = OrgUtil.getChildrenOrgListIncludeSelf((String)reqVo.getCompanyOrgCode());
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)childrenOrgListIncludeSelf)) {
                throw new Fault((Throwable)new SOAPException("\u516c\u53f8\u4ee3\u7801\u9519\u8bef\uff0c\u4f01\u4e1a\u7ec4\u7ec7\u67e5\u8be2\u4e0d\u5230\u76f8\u5173\u4fe1\u606f"));
            }
            List orgCodes = childrenOrgListIncludeSelf.stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
            reqVo.setOrgCodes(orgCodes);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(list = this.kmsOrderFormMapper.findList((Page<KmsOrderFormRespVo>)(page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize())), reqVo))) {
            List<String> createOrgCodes = list.stream().map(CrmBaseVo::getCreateOrgCode).distinct().collect(Collectors.toList());
            Map<String, String> orgCompanyMap = KmsOrgUtil.findCompanyByCreateOrgCodes(createOrgCodes);
            List<String> ids = list.stream().map(KmsOrderFormRespVo::getStoreRelatedId).distinct().collect(Collectors.toList());
            List<KmsOrderFormRespVo> nameList = this.kmsOrderFormMapper.findAreaName(ids);
            Map<String, List<KmsOrderFormRespVo>> areaNameMap = nameList.stream().collect(Collectors.groupingBy(UuidVo::getId));
            list.forEach(o -> {
                o.setOwnedCompany((String)orgCompanyMap.get(o.getCreateOrgCode()));
                List vos = (List)areaNameMap.get(o.getStoreRelatedId());
                if (CollectionUtil.listNotEmptyNotSizeZero((List)vos)) {
                    o.setAreaName(((KmsOrderFormRespVo)vos.get(0)).getAreaName());
                }
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public KmsOrderFormRespVo query(KmsOrderFormReqVo reqVo) {
        String id = reqVo.getId();
        AssertUtils.isNotEmpty((String)id, (String)"\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
        KmsOrderFormEntity orderFormEntity = (KmsOrderFormEntity)this.kmsOrderFormMapper.selectById((Serializable)((Object)id));
        AssertUtils.isNotNull((Object)orderFormEntity, (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\u4fe1\u606f");
        KmsOrderFormRespVo formRespVo = (KmsOrderFormRespVo)CrmBeanUtil.copy((Object)orderFormEntity, KmsOrderFormRespVo.class);
        String orderNumber = formRespVo.getOrderNumber();
        List goodsEntities = ((LambdaQueryChainWrapper)this.kmsOrderGoodsService.lambdaQuery().eq(KmsOrderGoodsEntity::getOrderNumber, (Object)orderNumber)).list();
        List goodsSortedEntities = goodsEntities.stream().sorted(Comparator.comparing(KmsOrderGoodsEntity::getItemIndex)).collect(Collectors.toList());
        formRespVo.setGoodsVos(CrmBeanUtil.copyList(goodsSortedEntities, KmsOrderGoodsRespVo.class));
        return formRespVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(KmsOrderFormReqVo reqVo) {
        KmsOrderFormEntity entity = (KmsOrderFormEntity)CrmBeanUtil.copy((Object)reqVo, KmsOrderFormEntity.class);
        this.save(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(KmsOrderFormReqVo reqVo) {
        KmsOrderFormEntity entity = (KmsOrderFormEntity)this.getById((Serializable)((Object)reqVo.getId()));
        this.updateById(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        if (CollectionUtil.listEmpty(ids)) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u64cd\u4f5c!");
        }
        List kmsOrderFormEntities = this.kmsOrderFormMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)kmsOrderFormEntities)) {
            kmsOrderFormEntities.forEach(o -> {
                if (!StringUtils.isEmpty((String)o.getSapNumber())) {
                    throw new BusinessException(o.getOrderNumber() + "\u8ba2\u5355\u5df2\u7ecf\u63a8\u9001SAP\uff01");
                }
            });
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseIdEntity::getId, ids);
        this.kmsOrderFormMapper.delete((Wrapper)updateWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(KmsOrderFormReqVo reqVo) {
        List kmsOrderFormEntities = this.kmsOrderFormMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)kmsOrderFormEntities)) {
            kmsOrderFormEntities.forEach(o -> {
                if (!StringUtils.isEmpty((String)o.getSapNumber())) {
                    throw new BusinessException(o.getOrderNumber() + "\u8ba2\u5355\u5df2\u7ecf\u63a8\u9001SAP\uff01");
                }
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(kmsOrderFormEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(KmsOrderFormReqVo reqVo) {
        List kmsOrderFormEntities = this.kmsOrderFormMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)kmsOrderFormEntities)) {
            kmsOrderFormEntities.forEach(o -> {
                if (!StringUtils.isEmpty((String)o.getSapNumber())) {
                    throw new BusinessException(o.getOrderNumber() + "\u8ba2\u5355\u5df2\u7ecf\u63a8\u9001SAP\uff01");
                }
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(kmsOrderFormEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void expedited(KmsOrderFormReqVo reqVo) {
        List kmsOrderFormEntities = this.kmsOrderFormMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)kmsOrderFormEntities)) {
            kmsOrderFormEntities.forEach(o -> {
                if (!StringUtils.isEmpty((String)o.getSapNumber())) {
                    throw new BusinessException(o.getOrderNumber() + "\u8ba2\u5355\u5df2\u7ecf\u63a8\u9001SAP\uff01");
                }
                o.setIsExpedited("\u662f");
            });
        }
        this.updateBatchById(kmsOrderFormEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancelExpedited(KmsOrderFormReqVo reqVo) {
        List kmsOrderFormEntities = this.kmsOrderFormMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)kmsOrderFormEntities)) {
            kmsOrderFormEntities.forEach(o -> {
                if (!StringUtils.isEmpty((String)o.getSapNumber())) {
                    throw new BusinessException(o.getOrderNumber() + "\u8ba2\u5355\u5df2\u7ecf\u63a8\u9001SAP\uff01");
                }
                o.setIsExpedited(null);
            });
        }
        this.updateBatchById(kmsOrderFormEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void manualTrans(KmsOrderFormReqVo kmsOrderFormReqVo) {
        List ids = kmsOrderFormReqVo.getIds();
        AssertUtils.isNotEmpty((Collection)ids, (String)"\u8bf7\u9009\u62e9\u5f85\u8f6c\u6362\u6570\u636e");
        if (ids.size() > 100) {
            throw new BusinessException("\u6700\u591a\u53ea\u80fd\u5904\u7406100\u6761\u6570\u636e\uff01");
        }
        List orderFormEntities = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, (Collection)ids)).list();
        orderFormEntities.forEach(o -> {
            if (YesNoEnum.yesNoEnum.no.getValue().equals(o.getIsTrans())) {
                throw new BusinessException("[" + o.getOrderNumber() + "]\u4e0d\u80fd\u518d\u6b21\u8f6c\u6362!");
            }
        });
        List dwRespVos = CrmBeanUtil.copyList((List)orderFormEntities, KmsOrderFormDetailDwRespVo.class);
        dwRespVos.forEach(o -> {
            KmsOrderFormEntity orderFormEntity = this.kmsOrderFormHelper.transFormVersion((KmsOrderFormDetailDwRespVo)o);
            List<KmsOrderGoodsEntity> goodsEntities = this.kmsOrderFormHelper.transGoodsVersion(orderFormEntity);
            this.kmsOrderFormHelper.transData(orderFormEntity, goodsEntities);
            this.saveOrUpdate(orderFormEntity);
            this.kmsOrderGoodsService.saveOrUpdateBatch(goodsEntities);
            this.kmsOrderStatusRecordService.insert(orderFormEntity);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void autoTransData(KmsOrderFormDetailDwRespVo dwRespVo) {
        KmsOrderFormEntity orderFormEntity = this.kmsOrderFormHelper.transFormVersion(dwRespVo);
        if (!ObjectUtils.isEmpty((Object)orderFormEntity) && ObjectUtils.isEmpty((Object)orderFormEntity.getSapNumber())) {
            List<KmsOrderGoodsEntity> goodsEntities = this.kmsOrderFormHelper.transGoodsVersion(orderFormEntity);
            this.kmsOrderFormHelper.transData(orderFormEntity, goodsEntities);
            this.saveOrUpdate(orderFormEntity);
            this.kmsOrderGoodsService.saveOrUpdateBatch(goodsEntities);
            this.kmsOrderStatusRecordService.insert(orderFormEntity);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<KmsOrderFormRespVo> pushList(KmsOrderFormReqVo params) {
        AssertUtils.isNotEmpty((Collection)params.getIds(), (String)"\u8bf7\u9009\u62e9\u9700\u8981\u63a8\u9001\u7684\u5355\u636e\u4fe1\u606f");
        if (params.getIds().size() > 5) {
            throw new BusinessException("\u6700\u591a\u53ea\u80fd\u5904\u74065\u6761\u6570\u636e\uff01");
        }
        List orderFormEntities = this.listByIds(params.getIds());
        orderFormEntities.forEach(o -> {
            if (!StringUtils.isEmpty((String)o.getSapNumber())) {
                throw new BusinessException(o.getOrderNumber() + "\u8ba2\u5355\u5df2\u7ecf\u63a8\u9001SAP\uff01");
            }
        });
        ArrayList goodsEntitiesAll = Lists.newArrayList();
        orderFormEntities.forEach(o -> {
            List goodsEntities = ((LambdaQueryChainWrapper)this.kmsOrderGoodsService.lambdaQuery().in(KmsOrderGoodsEntity::getOrderNumber, new Object[]{o.getOrderNumber()})).list();
            this.kmsOrderFormHelper.transData((KmsOrderFormEntity)o, goodsEntities);
            this.saveOrUpdate(o);
            this.kmsOrderGoodsService.saveOrUpdateBatch(goodsEntities);
            this.kmsOrderStatusRecordService.insert((KmsOrderFormEntity)o);
            goodsEntitiesAll.addAll(goodsEntities);
        });
        List respVos = CrmBeanUtil.copyList((List)orderFormEntities, KmsOrderFormRespVo.class);
        Map<String, List<KmsOrderGoodsEntity>> goodsMap = goodsEntitiesAll.stream().collect(Collectors.groupingBy(KmsOrderGoodsEntity::getOrderNumber));
        respVos.forEach(o -> o.setGoodsVos(CrmBeanUtil.copyList((List)((List)goodsMap.get(o.getOrderNumber())), KmsOrderGoodsRespVo.class)));
        return respVos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void push(KmsOrderFormReqVo params) {
        KmsOrderFormEntity orderFormEntity = (KmsOrderFormEntity)this.getById((Serializable)((Object)params.getId()));
        KmsTenantryDirectCustomerOrgRespVo customerOrgRespVo = this.kmsTenantryDirectCustomerOrgService.query(orderFormEntity.getBsDirectSystemId());
        List goodsEntities = ((LambdaQueryChainWrapper)this.kmsOrderGoodsService.lambdaQuery().eq(KmsOrderGoodsEntity::getOrderNumber, (Object)orderFormEntity.getOrderNumber())).list();
        this.kmsSapHelper.push(orderFormEntity, goodsEntities, customerOrgRespVo.getTimeOfDay());
        this.saveOrUpdate(orderFormEntity);
        this.kmsOrderGoodsService.saveOrUpdateBatch(goodsEntities);
        this.kmsOrderStatusRecordService.insert(orderFormEntity);
    }

    @Override
    public PageResult<KmsOrderFormExportRespVo> listFprExport(KmsOrderFormReqVo reqVo) {
        Page page;
        List<KmsOrderFormExportRespVo> list;
        AssertUtils.isNotEmpty((String)reqVo.getOrderDateStart(), (String)"\u8ba2\u5355\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getOrderDateEnd(), (String)"\u8ba2\u5355\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isNotEmpty((String)reqVo.getCompanyOrgCode())) {
            List childrenOrgListIncludeSelf = OrgUtil.getChildrenOrgListIncludeSelf((String)reqVo.getCompanyOrgCode());
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)childrenOrgListIncludeSelf)) {
                throw new Fault((Throwable)new SOAPException("\u516c\u53f8\u4ee3\u7801\u9519\u8bef\uff0c\u4f01\u4e1a\u7ec4\u7ec7\u67e5\u8be2\u4e0d\u5230\u76f8\u5173\u4fe1\u606f"));
            }
            List orgCodes = childrenOrgListIncludeSelf.stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
            reqVo.setOrgCodes(orgCodes);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(list = this.kmsOrderFormMapper.findListForExport((Page<KmsOrderFormExportRespVo>)(page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize())), reqVo))) {
            List<String> createOrgCodes = list.stream().map(CrmBaseVo::getCreateOrgCode).distinct().collect(Collectors.toList());
            Map<String, String> orgCompanyMap = KmsOrgUtil.findCompanyByCreateOrgCodes(createOrgCodes);
            list.forEach(o -> o.setOwnedCompany((String)orgCompanyMap.get(o.getCreateOrgCode())));
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }
}

