/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.orderform.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.kms.orderform.req.KmsOrderGoodsReqVo;
import com.biz.crm.nebular.kms.orderform.resp.KmsOrderGoodsRespVo;
import com.biz.crm.orderform.mapper.KmsOrderGoodsMapper;
import com.biz.crm.orderform.model.KmsOrderGoodsEntity;
import com.biz.crm.orderform.service.IKmsOrderGoodsService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"KmsOrderGoodsServiceExpandImpl"})
public class KmsOrderGoodsServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<KmsOrderGoodsMapper, KmsOrderGoodsEntity>
implements IKmsOrderGoodsService {
    private static final Logger log = LoggerFactory.getLogger(KmsOrderGoodsServiceImpl.class);
    @Resource
    private KmsOrderGoodsMapper kmsOrderGoodsMapper;

    @Override
    public PageResult<KmsOrderGoodsRespVo> findList(KmsOrderGoodsReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<KmsOrderGoodsRespVo> list = this.kmsOrderGoodsMapper.findList((Page<KmsOrderGoodsRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public KmsOrderGoodsRespVo query(KmsOrderGoodsReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(KmsOrderGoodsReqVo reqVo) {
        KmsOrderGoodsEntity entity = (KmsOrderGoodsEntity)CrmBeanUtil.copy((Object)reqVo, KmsOrderGoodsEntity.class);
        this.save(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(KmsOrderGoodsReqVo reqVo) {
        KmsOrderGoodsEntity entity = (KmsOrderGoodsEntity)this.getById((Serializable)((Object)reqVo.getId()));
        this.updateById(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(KmsOrderGoodsReqVo reqVo) {
        List kmsOrderGoodsEntities = this.kmsOrderGoodsMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)kmsOrderGoodsEntities)) {
            kmsOrderGoodsEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(kmsOrderGoodsEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(KmsOrderGoodsReqVo reqVo) {
        List kmsOrderGoodsEntities = this.kmsOrderGoodsMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)kmsOrderGoodsEntities)) {
            kmsOrderGoodsEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(kmsOrderGoodsEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(KmsOrderGoodsReqVo reqVo) {
        List kmsOrderGoodsEntities = this.kmsOrderGoodsMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)kmsOrderGoodsEntities)) {
            kmsOrderGoodsEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(kmsOrderGoodsEntities);
    }
}

