/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.orderform.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.kms.orderform.req.KmsOrderStatusRecordReqVo;
import com.biz.crm.nebular.kms.orderform.resp.KmsOrderStatusRecordRespVo;
import com.biz.crm.orderform.mapper.KmsOrderStatusRecordMapper;
import com.biz.crm.orderform.model.KmsOrderFormEntity;
import com.biz.crm.orderform.model.KmsOrderStatusRecordEntity;
import com.biz.crm.orderform.service.IKmsOrderStatusRecordService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"KmsOrderStatusRecordServiceExpandImpl"})
public class KmsOrderStatusRecordServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<KmsOrderStatusRecordMapper, KmsOrderStatusRecordEntity>
implements IKmsOrderStatusRecordService {
    private static final Logger log = LoggerFactory.getLogger(KmsOrderStatusRecordServiceImpl.class);
    @Resource
    private KmsOrderStatusRecordMapper kmsOrderStatusRecordMapper;

    @Override
    public PageResult<KmsOrderStatusRecordRespVo> findList(KmsOrderStatusRecordReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<KmsOrderStatusRecordRespVo> list = this.kmsOrderStatusRecordMapper.findList((Page<KmsOrderStatusRecordRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public KmsOrderStatusRecordRespVo query(KmsOrderStatusRecordReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(KmsOrderStatusRecordReqVo reqVo) {
        KmsOrderStatusRecordEntity entity = (KmsOrderStatusRecordEntity)CrmBeanUtil.copy((Object)reqVo, KmsOrderStatusRecordEntity.class);
        this.save(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(KmsOrderStatusRecordReqVo reqVo) {
        KmsOrderStatusRecordEntity entity = (KmsOrderStatusRecordEntity)this.getById((Serializable)((Object)reqVo.getId()));
        this.updateById(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(KmsOrderStatusRecordReqVo reqVo) {
        List kmsOrderStatusRecordEntities = this.kmsOrderStatusRecordMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)kmsOrderStatusRecordEntities)) {
            kmsOrderStatusRecordEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(kmsOrderStatusRecordEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(KmsOrderStatusRecordReqVo reqVo) {
        List kmsOrderStatusRecordEntities = this.kmsOrderStatusRecordMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)kmsOrderStatusRecordEntities)) {
            kmsOrderStatusRecordEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(kmsOrderStatusRecordEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(KmsOrderStatusRecordReqVo reqVo) {
        List kmsOrderStatusRecordEntities = this.kmsOrderStatusRecordMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)kmsOrderStatusRecordEntities)) {
            kmsOrderStatusRecordEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(kmsOrderStatusRecordEntities);
    }

    @Override
    public void insert(List<KmsOrderFormEntity> orderFormEntities) {
        List recordEntities = CrmBeanUtil.copyList(orderFormEntities, KmsOrderStatusRecordEntity.class);
        recordEntities.forEach(o -> this.setNull((KmsOrderStatusRecordEntity)o));
        this.saveBatch(recordEntities);
    }

    private void setNull(KmsOrderStatusRecordEntity o) {
        o.setId(null);
        o.setCreateDate(null);
        o.setCreateDateAll(null);
        o.setCreateDateSecond(null);
        o.setUpdateDateAll(null);
        o.setUpdateDateSecond(null);
        o.setUpdateDate(null);
    }

    @Override
    public void insert(KmsOrderFormEntity orderFormEntities) {
        KmsOrderStatusRecordEntity recordEntity = (KmsOrderStatusRecordEntity)CrmBeanUtil.copy((Object)orderFormEntities, KmsOrderStatusRecordEntity.class);
        this.setNull(recordEntity);
        this.save(recordEntity);
    }
}

