/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.returnform.helper;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.kms.KmsAdminEnum;
import com.biz.crm.eunm.kms.KmsEnum;
import com.biz.crm.grabrule.mapper.KmsDataAuthMapper;
import com.biz.crm.nebular.kms.rawdata.resp.KmsReturnFormDetailDwRespVo;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.rawdata.model.KmsReturnFormDetailDwEntity;
import com.biz.crm.rawdata.model.KmsReturnGoodsDetailDwEntity;
import com.biz.crm.rawdata.service.IKmsReturnFormDetailDwService;
import com.biz.crm.rawdata.service.IKmsReturnGoodsDetailDwService;
import com.biz.crm.returnform.mapper.KmsReturnFormMapper;
import com.biz.crm.returnform.mapper.KmsReturnGoodsMapper;
import com.biz.crm.returnform.model.KmsReturnFormEntity;
import com.biz.crm.returnform.model.KmsReturnGoodsEntity;
import com.biz.crm.trans.service.IKmsTransDataService;
import com.biz.crm.trans.vo.TransDataGoodsVo;
import com.biz.crm.trans.vo.TransDataStoreVo;
import com.biz.crm.trans.vo.TransDataVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.KmsUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Component
public class KmsReturnFormHelper {
    private static final Logger log = LoggerFactory.getLogger(KmsReturnFormHelper.class);
    @Resource
    private KmsReturnFormMapper kmsReturnFormMapper;
    @Resource
    private KmsReturnGoodsMapper kmsReturnGoodsMapper;
    @Resource
    private IKmsReturnFormDetailDwService kmsReturnFormDetailDwService;
    @Resource
    private IKmsReturnGoodsDetailDwService kmsReturnGoodsDetailDwService;
    @Resource
    private IKmsTransDataService kmsTransDataService;
    @Resource
    private KmsDataAuthMapper kmsDataAuthMapper;

    public KmsReturnFormEntity transFormVersion(KmsReturnFormDetailDwRespVo dwRespVo) {
        String orderNumber = dwRespVo.getOrderNumber();
        ArrayList kmsReturnFormEntities = Lists.newArrayList();
        List returnDwEntities = ((LambdaQueryChainWrapper)this.kmsReturnFormDetailDwService.lambdaQuery().eq(KmsReturnFormDetailDwEntity::getOrderNumber, (Object)orderNumber)).list();
        KmsReturnFormDetailDwEntity dwEntity = returnDwEntities.stream().sorted(Comparator.comparing(KmsReturnFormDetailDwEntity::getVersionNumber).reversed()).findFirst().orElse(null);
        LambdaQueryWrapper build = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(KmsReturnFormEntity::getOrderNumber, (Object)orderNumber);
        KmsReturnFormEntity returnFormEntity = (KmsReturnFormEntity)this.kmsReturnFormMapper.selectOne((Wrapper)build);
        if (ObjectUtils.isEmpty((Object)returnFormEntity)) {
            returnFormEntity = (KmsReturnFormEntity)CrmBeanUtil.copy((Object)dwEntity, KmsReturnFormEntity.class);
            returnFormEntity.setBsDirectSystemId(dwRespVo.getBsDirectSystemId());
            returnFormEntity.setCreateCode(dwRespVo.getCreateCode());
            returnFormEntity.setCreateName(dwRespVo.getCreateName());
            returnFormEntity.setCreateOrgCode(dwRespVo.getCreateOrgCode());
            returnFormEntity.setCreateOrgName(dwRespVo.getCreateOrgName());
            returnFormEntity.setCreatePosCode(dwRespVo.getCreatePosCode());
            returnFormEntity.setCreatePosName(dwRespVo.getCreatePosName());
        } else {
            BeanUtils.copyProperties((Object)dwEntity, (Object)returnFormEntity, (String[])KmsUtils.ignoreProperties());
            returnFormEntity.setRemarks(dwEntity.getRemarks());
        }
        returnDwEntities.forEach(dw -> dw.setTransStatus(YesNoEnum.yesNoEnum.ONE.getValue()));
        this.kmsReturnFormDetailDwService.updateBatchById(returnDwEntities);
        return returnFormEntity;
    }

    public List<KmsReturnGoodsEntity> transGoodsVersion(KmsReturnFormEntity returnFormEntity) {
        String orderNumber = returnFormEntity.getOrderNumber();
        Integer versionNumber = returnFormEntity.getVersionNumber();
        LambdaUpdateWrapper wrapper = (LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(KmsReturnGoodsEntity::getOrderNumber, (Object)orderNumber);
        List deleteOrderGoodsEntities = this.kmsReturnGoodsMapper.selectList((Wrapper)wrapper);
        Map goodsMap = deleteOrderGoodsEntities.stream().collect(Collectors.toMap(o -> o.getOrderNumber() + "-" + o.getVersionNumber() + "-" + o.getKaGoodsCode(), Function.identity()));
        List detailDwEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.kmsReturnGoodsDetailDwService.lambdaQuery().eq(KmsReturnGoodsDetailDwEntity::getOrderNumber, (Object)orderNumber)).eq(KmsReturnGoodsDetailDwEntity::getVersionNumber, (Object)versionNumber)).list();
        Map dwEntityMap = detailDwEntities.stream().collect(Collectors.toMap(o -> o.getOrderNumber() + "-" + o.getVersionNumber() + "-" + o.getKaGoodsCode(), Function.identity(), (v1, v2) -> v1));
        HashMap onlyMap = Maps.newHashMap();
        detailDwEntities.forEach(o -> {
            KmsReturnGoodsEntity goodsEntity;
            String key = o.getOrderNumber() + "-" + o.getVersionNumber() + "-" + o.getKaGoodsCode();
            goodsEntity.setReturnAmount(StringUtils.isEmpty((Object)(goodsEntity = (KmsReturnGoodsEntity)CrmBeanUtil.copy((Object)o, KmsReturnGoodsEntity.class)).getReturnAmount()) ? "0" : goodsEntity.getReturnAmount());
            goodsEntity.setReturnAmountNot(StringUtils.isEmpty((Object)goodsEntity.getReturnAmountNot()) ? "0" : goodsEntity.getReturnAmountNot());
            goodsEntity.setCurUnitOrderQuantity(StringUtils.isEmpty((Object)goodsEntity.getCurUnitOrderQuantity()) ? "0" : goodsEntity.getCurUnitOrderQuantity());
            goodsEntity.setRemarks(o.getRemarks());
            if (!ObjectUtils.isEmpty(onlyMap.get(key))) {
                KmsReturnGoodsEntity en = (KmsReturnGoodsEntity)onlyMap.get(key);
                en.setReturnAmount(new BigDecimal(en.getReturnAmount()).add(new BigDecimal(goodsEntity.getReturnAmount())).toString());
                en.setReturnAmountNot(new BigDecimal(en.getReturnAmountNot()).add(new BigDecimal(goodsEntity.getReturnAmountNot())).toString());
                en.setCurUnitOrderQuantity(new BigDecimal(en.getCurUnitOrderQuantity()).add(new BigDecimal(goodsEntity.getCurUnitOrderQuantity())).toString());
                onlyMap.put(key, en);
            } else {
                KmsReturnGoodsEntity entity = ObjectUtils.isEmpty(goodsMap.get(key)) ? new KmsReturnGoodsEntity() : (KmsReturnGoodsEntity)goodsMap.get(key);
                BeanUtils.copyProperties((Object)goodsEntity, (Object)entity, (String[])KmsUtils.ignoreProperties());
                onlyMap.put(key, entity);
            }
        });
        ArrayList goodsIds = Lists.newArrayList();
        goodsMap.forEach((k, v) -> {
            if (ObjectUtils.isEmpty(dwEntityMap.get(k))) {
                goodsIds.add(v.getId());
            }
        });
        if (!CollectionUtils.isEmpty((Collection)goodsIds)) {
            this.kmsReturnGoodsMapper.deleteBatchIds(goodsIds);
        }
        ArrayList onlyList = Lists.newArrayList();
        onlyMap.forEach((k, v) -> onlyList.add(v));
        return onlyList;
    }

    public void transData(KmsReturnFormEntity returnFormEntity, List<KmsReturnGoodsEntity> goodsEntities) {
        TransDataVo transDataVo = new TransDataVo();
        transDataVo.setOrderType(KmsAdminEnum.OrderType.RETURN.getValue());
        returnFormEntity.setOrderStatusMsg("");
        TransDataStoreVo dataStoreVo = (TransDataStoreVo)((Object)CrmBeanUtil.copy((Object)returnFormEntity, TransDataStoreVo.class));
        dataStoreVo.setSoldToPartyCode(null);
        dataStoreVo.setSoldToPartyName(null);
        dataStoreVo.setKaOrderNumber(returnFormEntity.getKaOrderNumber());
        dataStoreVo.setOrderStatusMsg("");
        dataStoreVo.setKaName(returnFormEntity.getKaName());
        transDataVo.setStoreVos(dataStoreVo);
        HashMap goodsEntityMap = Maps.newHashMap();
        goodsEntities.forEach(o -> {
            List entities = (List)goodsEntityMap.get(o.getOrderNumber());
            if (CollectionUtils.isEmpty((Collection)entities)) {
                entities = Lists.newArrayList();
            }
            entities.add(o);
            goodsEntityMap.put(o.getOrderNumber(), entities);
            TransDataGoodsVo dataGoodsVo = (TransDataGoodsVo)((Object)((Object)CrmBeanUtil.copy((Object)o, TransDataGoodsVo.class)));
            dataGoodsVo.setKaOrderNumber(o.getKaOrderNumber());
            dataGoodsVo.setOrderStatusMsg("");
            dataGoodsVo.setKaName(o.getKaName());
            dataGoodsVo.setOrderDate(returnFormEntity.getOrderDate());
            transDataVo.getGoodsVos().add(dataGoodsVo);
        });
        this.kmsTransDataService.transData(transDataVo);
        this.resultProcessing(returnFormEntity, goodsEntities, transDataVo);
    }

    private void resultProcessing(KmsReturnFormEntity returnFormEntity, List<KmsReturnGoodsEntity> goodsEntities, TransDataVo transDataVo) {
        String orderNumber = returnFormEntity.getOrderNumber();
        TransDataStoreVo transDataStoreVo = transDataVo.getStoreVos();
        BeanUtils.copyProperties((Object)((Object)transDataStoreVo), (Object)returnFormEntity, (String[])Arrays.stream(CrmBaseVo.class.getDeclaredFields()).map(Field::getName).collect(Collectors.toList()).toArray(new String[0]));
        Map dataGoodsVoMap = transDataVo.getGoodsVos().stream().collect(Collectors.toMap(TransDataGoodsVo::getKaGoodsCode, Function.identity()));
        goodsEntities.forEach(goods -> {
            String kaGoodsCode = goods.getKaGoodsCode();
            TransDataGoodsVo transDataGoodsVo = (TransDataGoodsVo)((Object)((Object)dataGoodsVoMap.get(kaGoodsCode)));
            BeanUtils.copyProperties((Object)((Object)transDataGoodsVo), (Object)goods, (String[])Arrays.stream(CrmBaseVo.class.getDeclaredFields()).map(Field::getName).collect(Collectors.toList()).toArray(new String[0]));
            if (!StringUtils.isEmpty((Object)goods.getOrderStatusMsg())) {
                goods.setOrderStatus(KmsEnum.OrderStatus.S100.getValue());
            } else {
                goods.setOrderStatus(KmsEnum.OrderStatus.S400.getValue());
                goods.setOrderStatusMsg("\u8f6c\u6362\u6210\u529f");
            }
        });
        String orderStatusMsg = returnFormEntity.getOrderStatusMsg();
        List errorList = goodsEntities.stream().filter(goods -> KmsEnum.OrderStatus.S100.getValue().equals(goods.getOrderStatus())).collect(Collectors.toList());
        if (!StringUtils.isEmpty((Object)orderStatusMsg) || !CollectionUtils.isEmpty(errorList)) {
            returnFormEntity.setOrderStatus(KmsEnum.OrderStatus.S100.getValue());
            if (!CollectionUtils.isEmpty(errorList) && !StringUtils.isEmpty((Object)orderStatusMsg)) {
                returnFormEntity.setOrderStatusMsg(orderStatusMsg + "|\u5546\u54c1\u884c\u4fe1\u606f\u5b58\u5728\u8f6c\u6362\u5931\u8d25\u6570\u636e");
            } else if (!CollectionUtils.isEmpty(errorList) && StringUtils.isEmpty((Object)orderStatusMsg)) {
                returnFormEntity.setOrderStatusMsg("\u5546\u54c1\u884c\u4fe1\u606f\u5b58\u5728\u8f6c\u6362\u5931\u8d25\u6570\u636e");
            }
        } else {
            returnFormEntity.setOrderStatus(KmsEnum.OrderStatus.S400.getValue());
        }
        if (StringUtils.isEmpty((Object)returnFormEntity.getOrderStatusMsg())) {
            returnFormEntity.setOrderStatusMsg("\u8f6c\u6362\u6210\u529f");
        }
    }
}

