/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.salesdata.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.kms.KmsAdminEnum;
import com.biz.crm.nebular.kms.salesdata.req.KmsSalesDataReqVo;
import com.biz.crm.nebular.kms.salesdata.resp.KmsSalesDataRespVo;
import com.biz.crm.salesdata.service.IKmsSalesDataService;
import com.biz.crm.util.RedissonUtil;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.redisson.api.RLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/kmssalesdata"})
@Api(tags={"\u5546\u8d85\u5355\u636e-\u9500\u552e\u6570\u636e"})
public class KmsSalesDataController {
    private static final Logger log = LoggerFactory.getLogger(KmsSalesDataController.class);
    @Autowired
    private IKmsSalesDataService kmsSalesDataService;
    @Resource
    private RedissonUtil redissonUtil;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    public Result<PageResult<KmsSalesDataRespVo>> list(@RequestBody KmsSalesDataReqVo kmsSalesDataReqVo) {
        PageResult<KmsSalesDataRespVo> result = this.kmsSalesDataService.findList(kmsSalesDataReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @PostMapping(value={"/query"})
    @CrmLog
    public Result<KmsSalesDataRespVo> query(@RequestParam(value="id") String id) {
        KmsSalesDataRespVo respVo = this.kmsSalesDataService.query(id);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody KmsSalesDataReqVo kmsSalesDataReqVo) {
        this.kmsSalesDataService.save(kmsSalesDataReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody KmsSalesDataReqVo kmsSalesDataReqVo) {
        this.kmsSalesDataService.update(kmsSalesDataReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result deleteBatch(@RequestBody List<String> ids) {
        this.kmsSalesDataService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody KmsSalesDataReqVo kmsSalesDataReqVo) {
        this.kmsSalesDataService.enableBatch(kmsSalesDataReqVo);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody KmsSalesDataReqVo kmsSalesDataReqVo) {
        this.kmsSalesDataService.disableBatch(kmsSalesDataReqVo);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiOperation(value="\u624b\u52a8\u8f6c\u6362\u9500\u552e\u6570\u636e")
    @PostMapping(value={"/manualTrans"})
    @CrmLog
    public Result manualTrans(@RequestBody List<String> ids) {
        RLock rLock = null;
        try {
            rLock = this.redissonUtil.createLock("MANUAL_TRANS_FORM_" + KmsAdminEnum.OrderType.SALES_DATA.getValue());
            if (!this.redissonUtil.tryLock(rLock, 0L, 3600L)) throw new BusinessException("\u6709\u4eba\u6b63\u5728\u8fdb\u884c\u6570\u636e\u8f6c\u6362\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            KmsSalesDataReqVo kmsSalesDataReqVo = new KmsSalesDataReqVo();
            kmsSalesDataReqVo.setIds(ids);
            this.kmsSalesDataService.manualTrans(kmsSalesDataReqVo);
        }
        catch (BusinessException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                this.redissonUtil.unLock(rLock);
                throw throwable;
            }
        }
        this.redissonUtil.unLock(rLock);
        return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
    }
}

