/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.salesdata.helper;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.kms.KmsAdminEnum;
import com.biz.crm.eunm.kms.KmsEnum;
import com.biz.crm.nebular.kms.rawdata.resp.KmsSaleDataFormDetailDwRespVo;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.rawdata.model.KmsSaleDataFormDetailDwEntity;
import com.biz.crm.rawdata.service.IKmsSaleDataFormDetailDwService;
import com.biz.crm.salesdata.mapper.KmsSalesDataMapper;
import com.biz.crm.salesdata.model.KmsSalesDataEntity;
import com.biz.crm.trans.service.IKmsTransDataService;
import com.biz.crm.trans.vo.TransDataGoodsVo;
import com.biz.crm.trans.vo.TransDataStoreVo;
import com.biz.crm.trans.vo.TransDataVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.KmsUtils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Component
public class KmsSalesDataHelper {
    private static final Logger log = LoggerFactory.getLogger(KmsSalesDataHelper.class);
    @Resource
    private IKmsSaleDataFormDetailDwService kmsSaleDataFormDetailDwService;
    @Resource
    private KmsSalesDataMapper kmsSalesDataMapper;
    @Resource
    private IKmsTransDataService kmsTransDataService;

    public KmsSalesDataEntity transFormVersion(KmsSaleDataFormDetailDwRespVo dwRespVo) {
        String orderNumber = dwRespVo.getOrderNumber();
        KmsSaleDataFormDetailDwEntity dwEntity = (KmsSaleDataFormDetailDwEntity)((LambdaQueryChainWrapper)this.kmsSaleDataFormDetailDwService.lambdaQuery().eq(KmsSaleDataFormDetailDwEntity::getOrderNumber, (Object)orderNumber)).one();
        if (ObjectUtils.isEmpty((Object)dwEntity)) {
            return null;
        }
        LambdaQueryWrapper build = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(KmsSalesDataEntity::getOrderNumber, (Object)orderNumber);
        KmsSalesDataEntity kmsSalesDataEntity = (KmsSalesDataEntity)this.kmsSalesDataMapper.selectOne((Wrapper)build);
        if (ObjectUtils.isEmpty((Object)kmsSalesDataEntity)) {
            kmsSalesDataEntity = (KmsSalesDataEntity)CrmBeanUtil.copy((Object)dwEntity, KmsSalesDataEntity.class);
            kmsSalesDataEntity.setCreateCode(dwRespVo.getCreateCode());
            kmsSalesDataEntity.setCreateName(dwRespVo.getCreateName());
            kmsSalesDataEntity.setCreateOrgCode(dwRespVo.getCreateOrgCode());
            kmsSalesDataEntity.setCreateOrgName(dwRespVo.getCreateOrgName());
            kmsSalesDataEntity.setCreatePosCode(dwRespVo.getCreatePosCode());
            kmsSalesDataEntity.setCreatePosName(dwRespVo.getCreatePosName());
            kmsSalesDataEntity.setBsDirectSystemId(dwRespVo.getBsDirectSystemId());
        } else if (!KmsEnum.OrderStatus.S600.getValue().equals(kmsSalesDataEntity.getOrderStatus())) {
            BeanUtils.copyProperties((Object)dwEntity, (Object)kmsSalesDataEntity, (String[])KmsUtils.ignoreProperties());
            kmsSalesDataEntity.setRemarks(dwEntity.getRemarks());
        }
        dwEntity.setTransStatus(YesNoEnum.yesNoEnum.ONE.getValue());
        this.kmsSaleDataFormDetailDwService.updateById(dwEntity);
        return kmsSalesDataEntity;
    }

    public void transData(KmsSalesDataEntity salesDataEntity) {
        TransDataVo transDataVo = new TransDataVo();
        transDataVo.setOrderType(KmsAdminEnum.OrderType.SALES_DATA.getValue());
        salesDataEntity.setOrderStatusMsg("");
        TransDataStoreVo dataStoreVo = (TransDataStoreVo)((Object)CrmBeanUtil.copy((Object)salesDataEntity, TransDataStoreVo.class));
        dataStoreVo.setOrderStatusMsg("");
        dataStoreVo.setKaName(salesDataEntity.getKaName());
        dataStoreVo.setKaOrderNumber(salesDataEntity.getKaOrderNumber());
        transDataVo.setStoreVos(dataStoreVo);
        TransDataGoodsVo dataGoodsVo = (TransDataGoodsVo)((Object)CrmBeanUtil.copy((Object)salesDataEntity, TransDataGoodsVo.class));
        dataGoodsVo.setCurUnitOrderQuantity(salesDataEntity.getCurUnitSalesQuantity());
        dataGoodsVo.setKaOrderNumber(salesDataEntity.getKaOrderNumber());
        dataGoodsVo.setOrderStatusMsg("");
        dataGoodsVo.setKaName(salesDataEntity.getKaName());
        dataGoodsVo.setOrderDate(salesDataEntity.getSalesDate());
        transDataVo.getGoodsVos().add(dataGoodsVo);
        this.kmsTransDataService.transData(transDataVo);
        this.resultProcessing(salesDataEntity, transDataVo);
    }

    private void resultProcessing(KmsSalesDataEntity salesDataEntity, TransDataVo transDataVo) {
        String orderNumber = salesDataEntity.getOrderNumber();
        TransDataStoreVo transDataStoreVo = transDataVo.getStoreVos();
        String orderStatusMsg = salesDataEntity.getOrderStatusMsg();
        TransDataGoodsVo transDataGoodsVo = transDataVo.getGoodsVos().get(0);
        BeanUtils.copyProperties((Object)((Object)transDataGoodsVo), (Object)salesDataEntity, (String[])Arrays.stream(CrmBaseVo.class.getDeclaredFields()).map(Field::getName).collect(Collectors.toList()).toArray(new String[0]));
        salesDataEntity.setKaCode(transDataStoreVo.getKaCode());
        salesDataEntity.setStoreCode(transDataStoreVo.getStoreCode());
        salesDataEntity.setStoreName(transDataStoreVo.getStoreName());
        salesDataEntity.setAreaName(transDataStoreVo.getAreaName());
        if (!StringUtils.isEmpty((Object)transDataStoreVo.getOrderStatusMsg()) || !StringUtils.isEmpty((Object)transDataGoodsVo.getOrderStatusMsg())) {
            salesDataEntity.setOrderStatus(KmsEnum.OrderStatus.S100.getValue());
            salesDataEntity.setOrderStatusMsg(transDataStoreVo.getOrderStatusMsg() + "|" + transDataGoodsVo.getOrderStatusMsg());
        } else {
            salesDataEntity.setOrderStatus(KmsEnum.OrderStatus.S400.getValue());
            salesDataEntity.setOrderStatusMsg(KmsEnum.OrderStatus.S400.getDescription());
        }
    }
}

