/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.stockdata.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.kms.KmsAdminEnum;
import com.biz.crm.nebular.kms.stockdata.req.KmsStockDataReqVo;
import com.biz.crm.nebular.kms.stockdata.resp.KmsStockDataRespVo;
import com.biz.crm.stockdata.service.IKmsStockDataService;
import com.biz.crm.util.RedissonUtil;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.redisson.api.RLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/kmsstockdata"})
@Api(tags={"\u5546\u8d85\u5355\u636e-\u5e93\u5b58\u6570\u636e"})
public class KmsStockDataController {
    private static final Logger log = LoggerFactory.getLogger(KmsStockDataController.class);
    @Autowired
    private IKmsStockDataService kmsStockDataService;
    @Resource
    private RedissonUtil redissonUtil;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    @CrmDictMethod
    public Result<PageResult<KmsStockDataRespVo>> list(@RequestBody KmsStockDataReqVo kmsStockDataReqVo) {
        PageResult<KmsStockDataRespVo> result = this.kmsStockDataService.findList(kmsStockDataReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @PostMapping(value={"/query"})
    @CrmLog
    @CrmDictMethod
    public Result<KmsStockDataRespVo> query(@RequestParam(value="id", required=false) String id) {
        KmsStockDataRespVo respVo = this.kmsStockDataService.query(id);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody KmsStockDataReqVo kmsStockDataReqVo) {
        this.kmsStockDataService.save(kmsStockDataReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody KmsStockDataReqVo kmsStockDataReqVo) {
        this.kmsStockDataService.update(kmsStockDataReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result deleteBatch(@RequestBody List<String> ids) {
        this.kmsStockDataService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody KmsStockDataReqVo kmsStockDataReqVo) {
        this.kmsStockDataService.enableBatch(kmsStockDataReqVo);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody KmsStockDataReqVo kmsStockDataReqVo) {
        this.kmsStockDataService.disableBatch(kmsStockDataReqVo);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiOperation(value="\u624b\u52a8\u8f6c\u6362\u5e93\u5b58\u6570\u636e")
    @PostMapping(value={"/manualTrans"})
    @CrmLog
    public Result manualTrans(@RequestBody List<String> ids) {
        RLock rLock = null;
        try {
            rLock = this.redissonUtil.createLock("MANUAL_TRANS_FORM_" + KmsAdminEnum.OrderType.INVENTORY_DATA.getValue());
            if (!this.redissonUtil.tryLock(rLock, 0L, 3600L)) throw new BusinessException("\u6709\u4eba\u6b63\u5728\u8fdb\u884c\u6570\u636e\u8f6c\u6362\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            KmsStockDataReqVo kmsStockDataReqVo = new KmsStockDataReqVo();
            kmsStockDataReqVo.setIds(ids);
            this.kmsStockDataService.manualTrans(kmsStockDataReqVo);
        }
        catch (BusinessException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                this.redissonUtil.unLock(rLock);
                throw throwable;
            }
        }
        this.redissonUtil.unLock(rLock);
        return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
    }
}

