/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.stockdata.helper;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.kms.KmsAdminEnum;
import com.biz.crm.eunm.kms.KmsEnum;
import com.biz.crm.nebular.kms.rawdata.resp.KmsInventoryDataFormDetailDwRespVo;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.rawdata.model.KmsInventoryDataFormDetailDwEntity;
import com.biz.crm.rawdata.service.IKmsInventoryDataFormDetailDwService;
import com.biz.crm.stockdata.mapper.KmsStockDataMapper;
import com.biz.crm.stockdata.model.KmsStockDataEntity;
import com.biz.crm.trans.service.IKmsTransDataService;
import com.biz.crm.trans.vo.TransDataGoodsVo;
import com.biz.crm.trans.vo.TransDataStoreVo;
import com.biz.crm.trans.vo.TransDataVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.KmsUtils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Component
public class KmsStockDataHelper {
    private static final Logger log = LoggerFactory.getLogger(KmsStockDataHelper.class);
    @Resource
    private IKmsInventoryDataFormDetailDwService kmsInventoryDataFormDetailDwService;
    @Resource
    private KmsStockDataMapper kmsStockDataMapper;
    @Resource
    private IKmsTransDataService kmsTransDataService;

    public KmsStockDataEntity transFormVersion(KmsInventoryDataFormDetailDwRespVo dwRespVo) {
        String orderNumber = dwRespVo.getOrderNumber();
        KmsInventoryDataFormDetailDwEntity dwEntity = (KmsInventoryDataFormDetailDwEntity)((LambdaQueryChainWrapper)this.kmsInventoryDataFormDetailDwService.lambdaQuery().eq(KmsInventoryDataFormDetailDwEntity::getOrderNumber, (Object)orderNumber)).one();
        if (ObjectUtils.isEmpty((Object)dwEntity)) {
            return null;
        }
        LambdaQueryWrapper build = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(KmsStockDataEntity::getOrderNumber, (Object)orderNumber);
        KmsStockDataEntity kmsStockDataEntity = (KmsStockDataEntity)this.kmsStockDataMapper.selectOne((Wrapper)build);
        if (ObjectUtils.isEmpty((Object)kmsStockDataEntity)) {
            kmsStockDataEntity = (KmsStockDataEntity)CrmBeanUtil.copy((Object)dwEntity, KmsStockDataEntity.class);
            kmsStockDataEntity.setCreateCode(dwRespVo.getCreateCode());
            kmsStockDataEntity.setCreateName(dwRespVo.getCreateName());
            kmsStockDataEntity.setCreateOrgCode(dwRespVo.getCreateOrgCode());
            kmsStockDataEntity.setCreateOrgName(dwRespVo.getCreateOrgName());
            kmsStockDataEntity.setCreatePosCode(dwRespVo.getCreatePosCode());
            kmsStockDataEntity.setCreatePosName(dwRespVo.getCreatePosName());
            kmsStockDataEntity.setBsDirectSystemId(dwRespVo.getBsDirectSystemId());
        } else if (!KmsEnum.OrderStatus.S600.getValue().equals(kmsStockDataEntity.getOrderStatus())) {
            BeanUtils.copyProperties((Object)dwEntity, (Object)kmsStockDataEntity, (String[])KmsUtils.ignoreProperties());
            kmsStockDataEntity.setRemarks(dwEntity.getRemarks());
        }
        dwEntity.setTransStatus(YesNoEnum.yesNoEnum.ONE.getValue());
        this.kmsInventoryDataFormDetailDwService.updateById(dwEntity);
        return kmsStockDataEntity;
    }

    public void transData(KmsStockDataEntity stockDataEntity) {
        TransDataVo transDataVo = new TransDataVo();
        transDataVo.setOrderType(KmsAdminEnum.OrderType.SALES_DATA.getValue());
        stockDataEntity.setOrderStatusMsg("");
        TransDataStoreVo dataStoreVo = (TransDataStoreVo)((Object)CrmBeanUtil.copy((Object)stockDataEntity, TransDataStoreVo.class));
        dataStoreVo.setOrderStatusMsg("");
        dataStoreVo.setKaName(stockDataEntity.getKaName());
        dataStoreVo.setKaOrderNumber(stockDataEntity.getKaOrderNumber());
        transDataVo.setStoreVos(dataStoreVo);
        TransDataGoodsVo dataGoodsVo = (TransDataGoodsVo)((Object)CrmBeanUtil.copy((Object)stockDataEntity, TransDataGoodsVo.class));
        dataGoodsVo.setCurUnitOrderQuantity(stockDataEntity.getCurUnitInventoryQuantity());
        dataGoodsVo.setKaOrderNumber(stockDataEntity.getKaOrderNumber());
        dataGoodsVo.setOrderStatusMsg("");
        dataGoodsVo.setKaName(stockDataEntity.getKaName());
        dataGoodsVo.setOrderDate(stockDataEntity.getInventoryDate());
        transDataVo.getGoodsVos().add(dataGoodsVo);
        this.kmsTransDataService.transData(transDataVo);
        this.resultProcessing(stockDataEntity, transDataVo);
    }

    private void resultProcessing(KmsStockDataEntity stockDataEntity, TransDataVo transDataVo) {
        String orderNumber = stockDataEntity.getOrderNumber();
        TransDataStoreVo transDataStoreVo = transDataVo.getStoreVos();
        TransDataGoodsVo transDataGoodsVo = transDataVo.getGoodsVos().get(0);
        BeanUtils.copyProperties((Object)((Object)transDataGoodsVo), (Object)stockDataEntity, (String[])Arrays.stream(CrmBaseVo.class.getDeclaredFields()).map(Field::getName).collect(Collectors.toList()).toArray(new String[0]));
        stockDataEntity.setKaCode(transDataStoreVo.getKaCode());
        stockDataEntity.setStoreCode(transDataStoreVo.getStoreCode());
        stockDataEntity.setStoreName(transDataStoreVo.getStoreName());
        stockDataEntity.setAreaName(transDataStoreVo.getAreaName());
        if (!StringUtils.isEmpty((Object)transDataStoreVo.getOrderStatusMsg()) || !StringUtils.isEmpty((Object)transDataGoodsVo.getOrderStatusMsg())) {
            stockDataEntity.setOrderStatus(KmsEnum.OrderStatus.S100.getValue());
            stockDataEntity.setOrderStatusMsg(transDataStoreVo.getOrderStatusMsg() + "|" + transDataGoodsVo.getOrderStatusMsg());
        } else {
            stockDataEntity.setOrderStatus(KmsEnum.OrderStatus.S400.getValue());
            stockDataEntity.setOrderStatusMsg(KmsEnum.OrderStatus.S400.getDescription());
        }
    }
}

