/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.stockdata.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.kms.rawdata.resp.KmsInventoryDataFormDetailDwRespVo;
import com.biz.crm.nebular.kms.stockdata.req.KmsStockDataReqVo;
import com.biz.crm.nebular.kms.stockdata.resp.KmsStockDataRespVo;
import com.biz.crm.stockdata.helper.KmsStockDataHelper;
import com.biz.crm.stockdata.mapper.KmsStockDataMapper;
import com.biz.crm.stockdata.model.KmsStockDataEntity;
import com.biz.crm.stockdata.service.IKmsStockDataService;
import com.biz.crm.supermarket.mapper.KmsTenantryDirectCustomerOrgMapper;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
@ConditionalOnMissingBean(name={"KmsStockDataServiceExpandImpl"})
public class KmsStockDataServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<KmsStockDataMapper, KmsStockDataEntity>
implements IKmsStockDataService {
    private static final Logger log = LoggerFactory.getLogger(KmsStockDataServiceImpl.class);
    @Resource
    private KmsStockDataMapper kmsStockDataMapper;
    @Resource
    private KmsStockDataHelper kmsStockDataHelper;
    @Resource
    private CrmLogSendUtil crmLogSendUtil;
    @Resource
    private KmsTenantryDirectCustomerOrgMapper orgMapper;

    @Override
    public PageResult<KmsStockDataRespVo> findList(KmsStockDataReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<KmsStockDataRespVo> list = this.kmsStockDataMapper.findList((Page<KmsStockDataRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public KmsStockDataRespVo query(String id) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(KmsStockDataReqVo reqVo) {
        KmsStockDataEntity entity = (KmsStockDataEntity)CrmBeanUtil.copy((Object)reqVo, KmsStockDataEntity.class);
        this.save(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(KmsStockDataReqVo reqVo) {
        KmsStockDataEntity entity = (KmsStockDataEntity)this.getById((Serializable)((Object)reqVo.getId()));
        this.updateById(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(KmsStockDataReqVo reqVo) {
        List kmsStockDataEntities = this.kmsStockDataMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)kmsStockDataEntities)) {
            kmsStockDataEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(kmsStockDataEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(KmsStockDataReqVo reqVo) {
        List kmsStockDataEntities = this.kmsStockDataMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)kmsStockDataEntities)) {
            kmsStockDataEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(kmsStockDataEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void autoTransData(KmsInventoryDataFormDetailDwRespVo dwRespVo) {
        KmsStockDataEntity stockDataEntity = this.kmsStockDataHelper.transFormVersion(dwRespVo);
        if (!ObjectUtils.isEmpty((Object)stockDataEntity)) {
            this.kmsStockDataHelper.transData(stockDataEntity);
            this.saveOrUpdate(stockDataEntity);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void manualTrans(KmsStockDataReqVo kmsStockDataReqVo) {
        List ids = kmsStockDataReqVo.getIds();
        AssertUtils.isNotEmpty((Collection)ids, (String)"\u8bf7\u9009\u62e9\u5f85\u8f6c\u6362\u6570\u636e");
        List kmsStockDataEntities = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, (Collection)ids)).list();
        List detailDwRespVos = CrmBeanUtil.copyList((List)kmsStockDataEntities, KmsInventoryDataFormDetailDwRespVo.class);
        detailDwRespVos.forEach(dwRespVo -> {
            KmsStockDataEntity kmsStockDataEntity = this.kmsStockDataHelper.transFormVersion((KmsInventoryDataFormDetailDwRespVo)dwRespVo);
            if (!ObjectUtils.isEmpty((Object)kmsStockDataEntity)) {
                this.kmsStockDataHelper.transData(kmsStockDataEntity);
                this.saveOrUpdate(kmsStockDataEntity);
            }
        });
    }
}

