/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.supermarket.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.kms.supermarket.req.KmsTotalWarehouseStoreReqVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsTotalWarehouseStoreRespVo;
import com.biz.crm.supermarket.service.IKmsTotalWarehouseStoreService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/kmstotalwarehousestore"})
@Api(tags={"\u603b\u4ed3\u95e8\u5e97"})
public class KmsTotalWarehouseStoreController {
    private static final Logger log = LoggerFactory.getLogger(KmsTotalWarehouseStoreController.class);
    @Autowired
    private IKmsTotalWarehouseStoreService kmsTotalWarehouseStoreService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    public Result<PageResult<KmsTotalWarehouseStoreRespVo>> list(@RequestBody KmsTotalWarehouseStoreReqVo kmsTotalWarehouseStoreReqVo) {
        PageResult<KmsTotalWarehouseStoreRespVo> result = this.kmsTotalWarehouseStoreService.findList(kmsTotalWarehouseStoreReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @PostMapping(value={"/query"})
    @CrmLog
    public Result<KmsTotalWarehouseStoreRespVo> query(@RequestBody KmsTotalWarehouseStoreReqVo reqVo) {
        KmsTotalWarehouseStoreRespVo respVo = this.kmsTotalWarehouseStoreService.query(reqVo.getId());
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody KmsTotalWarehouseStoreReqVo kmsTotalWarehouseStoreReqVo) {
        this.kmsTotalWarehouseStoreService.save(kmsTotalWarehouseStoreReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody KmsTotalWarehouseStoreReqVo kmsTotalWarehouseStoreReqVo) {
        this.kmsTotalWarehouseStoreService.update(kmsTotalWarehouseStoreReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        this.kmsTotalWarehouseStoreService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        this.kmsTotalWarehouseStoreService.enableBatch(ids);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        this.kmsTotalWarehouseStoreService.disableBatch(ids);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }
}

