/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.supermarket.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectAccountReqVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsTenantryDirectAccountRespVo;
import com.biz.crm.supermarket.mapper.KmsTenantryDirectAccountMapper;
import com.biz.crm.supermarket.model.KmsTenantryDirectAccountEntity;
import com.biz.crm.supermarket.service.IKmsTenantryDirectAccountService;
import com.biz.crm.supermarket.service.impl.KmsTenantryDirectHelper;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"KmsTenantryDirectAccountServiceExpandImpl"})
public class KmsTenantryDirectAccountServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<KmsTenantryDirectAccountMapper, KmsTenantryDirectAccountEntity>
implements IKmsTenantryDirectAccountService {
    private static final Logger log = LoggerFactory.getLogger(KmsTenantryDirectAccountServiceImpl.class);
    @Resource
    private KmsTenantryDirectAccountMapper kmsTenantryDirectAccountMapper;
    @Resource
    private KmsTenantryDirectHelper helper;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;

    @Override
    public PageResult<KmsTenantryDirectAccountRespVo> findList(KmsTenantryDirectAccountReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<KmsTenantryDirectAccountRespVo> list = this.kmsTenantryDirectAccountMapper.findList((Page<KmsTenantryDirectAccountRespVo>)page, reqVo);
        if (CollectionUtils.isNotEmpty(list)) {
            this.helper.convertAccountDate(list);
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public KmsTenantryDirectAccountRespVo query(String id) {
        AssertUtils.isNotEmpty((String)id, (CrmExceptionType)CommonException.IDS_NULL);
        KmsTenantryDirectAccountReqVo reqVo = new KmsTenantryDirectAccountReqVo();
        reqVo.setId(id);
        List list = this.findList(reqVo).getData();
        AssertUtils.isNotEmpty((Collection)list, (String)"\u67e5\u8be2\u6570\u636e\u4e0d\u5b58\u5728");
        return (KmsTenantryDirectAccountRespVo)list.get(0);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(KmsTenantryDirectAccountReqVo reqVo) {
        this.helper.checkSaveAccountData(reqVo);
        KmsTenantryDirectAccountEntity entity = (KmsTenantryDirectAccountEntity)CrmBeanUtil.copy((Object)reqVo, KmsTenantryDirectAccountEntity.class);
        this.save(entity);
        KmsTenantryDirectAccountRespVo newData = (KmsTenantryDirectAccountRespVo)CrmBeanUtil.copy((Object)entity, KmsTenantryDirectAccountRespVo.class);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        this.crmLogSendUtil.sendForAdd(menuCodeObj.toString(), newData.getId(), newData.getLoginAcc(), (Object)newData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(KmsTenantryDirectAccountReqVo reqVo) {
        this.helper.checkAccountUpdate(reqVo);
        this.helper.checkSaveAccountData(reqVo);
        KmsTenantryDirectAccountEntity entity = (KmsTenantryDirectAccountEntity)CrmBeanUtil.copy((Object)reqVo, KmsTenantryDirectAccountEntity.class);
        KmsTenantryDirectAccountRespVo oldData = this.query(reqVo.getId());
        this.updateById(entity);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        KmsTenantryDirectAccountRespVo newData = this.query(reqVo.getId());
        this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), newData.getId(), newData.getLoginAcc(), (Object)oldData, (Object)newData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List kmsTenantryDirectAccountEntities = this.kmsTenantryDirectAccountMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)kmsTenantryDirectAccountEntities)) {
            kmsTenantryDirectAccountEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(kmsTenantryDirectAccountEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List kmsTenantryDirectAccountEntities = this.kmsTenantryDirectAccountMapper.selectBatchIds(ids);
        List oldData = CrmBeanUtil.copyList((List)kmsTenantryDirectAccountEntities, KmsTenantryDirectAccountRespVo.class);
        if (CollectionUtils.isNotEmpty((Collection)kmsTenantryDirectAccountEntities)) {
            kmsTenantryDirectAccountEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(kmsTenantryDirectAccountEntities);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        List newData = CrmBeanUtil.copyList((List)kmsTenantryDirectAccountEntities, KmsTenantryDirectAccountRespVo.class);
        for (int n = 0; n < newData.size(); ++n) {
            this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), ((KmsTenantryDirectAccountRespVo)newData.get(n)).getId(), ((KmsTenantryDirectAccountRespVo)newData.get(n)).getLoginAcc(), oldData.get(n), newData.get(n));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List kmsTenantryDirectAccountEntities = this.kmsTenantryDirectAccountMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)kmsTenantryDirectAccountEntities)) {
            kmsTenantryDirectAccountEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(kmsTenantryDirectAccountEntities);
    }
}

