/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.supermarket.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.mdm.cusorg.MdmCusOrgFeign;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectCustomerOrgReqVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsTenantryDirectCustomerOrgRespVo;
import com.biz.crm.nebular.mdm.cusorg.CusOrgVo;
import com.biz.crm.nebular.mdm.cusorg.MdmCustomerOrgSelectRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.supermarket.mapper.KmsTenantryDirectCustomerOrgMapper;
import com.biz.crm.supermarket.model.KmsTenantryDirectCustomerOrgEntity;
import com.biz.crm.supermarket.service.IKmsTenantryDirectCustomerOrgService;
import com.biz.crm.supermarket.service.impl.KmsTenantryDirectHelper;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.xml.soap.SOAPException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.cxf.interceptor.Fault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"KmsTenantryDirectCustomerOrgServiceExpandImpl"})
public class KmsTenantryDirectCustomerOrgServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<KmsTenantryDirectCustomerOrgMapper, KmsTenantryDirectCustomerOrgEntity>
implements IKmsTenantryDirectCustomerOrgService {
    private static final Logger log = LoggerFactory.getLogger(KmsTenantryDirectCustomerOrgServiceImpl.class);
    @Resource
    private KmsTenantryDirectCustomerOrgMapper kmsTenantryDirectCustomerOrgMapper;
    @Resource
    private KmsTenantryDirectHelper helper;
    @Resource
    private MdmCusOrgFeign mdmCusOrgFeign;
    @Resource
    private CrmLogSendUtil crmLogSendUtil;

    @Override
    public PageResult<KmsTenantryDirectCustomerOrgRespVo> findList(KmsTenantryDirectCustomerOrgReqVo reqVo) {
        Page page;
        List<KmsTenantryDirectCustomerOrgRespVo> list;
        if (StringUtils.isNotEmpty((String)reqVo.getCompanyOrgCode())) {
            List childrenOrgListIncludeSelf = OrgUtil.getChildrenOrgListIncludeSelf((String)reqVo.getCompanyOrgCode());
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)childrenOrgListIncludeSelf)) {
                throw new Fault((Throwable)new SOAPException("\u516c\u53f8\u4ee3\u7801\u9519\u8bef\uff0c\u4f01\u4e1a\u7ec4\u7ec7\u67e5\u8be2\u4e0d\u5230\u76f8\u5173\u4fe1\u606f"));
            }
            List orgCodes = childrenOrgListIncludeSelf.stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
            reqVo.setOrgCodes(orgCodes);
        }
        if (reqVo.getPageSize() == null) {
            reqVo.setPageSize(Integer.valueOf(100));
        }
        if (CollectionUtils.isNotEmpty(list = this.kmsTenantryDirectCustomerOrgMapper.findList((Page<KmsTenantryDirectCustomerOrgRespVo>)(page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize())), reqVo))) {
            this.helper.convertData(list);
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public KmsTenantryDirectCustomerOrgRespVo query(String id) {
        AssertUtils.isNotEmpty((String)id, (CrmExceptionType)CommonException.IDS_NULL);
        KmsTenantryDirectCustomerOrgReqVo reqVo = new KmsTenantryDirectCustomerOrgReqVo();
        reqVo.setId(id);
        List list = this.findList(reqVo).getData();
        AssertUtils.isNotEmpty((Collection)list, (String)"\u67e5\u8be2\u6570\u636e\u4e0d\u5b58\u5728");
        return (KmsTenantryDirectCustomerOrgRespVo)list.get(0);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(KmsTenantryDirectCustomerOrgReqVo reqVo) {
        List<KmsTenantryDirectCustomerOrgEntity> list = this.helper.checkSaveData(reqVo);
        if (CollectionUtils.isNotEmpty(list)) {
            KmsTenantryDirectCustomerOrgEntity updateEntity = list.get(0);
            KmsTenantryDirectCustomerOrgRespVo oldData = (KmsTenantryDirectCustomerOrgRespVo)CrmBeanUtil.copy((Object)list.get(0), KmsTenantryDirectCustomerOrgRespVo.class);
            updateEntity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            updateEntity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
            this.updateById(updateEntity);
            Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
            KmsTenantryDirectCustomerOrgRespVo newData = this.query(updateEntity.getId());
            this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), newData.getId(), newData.getCustomerOrgCode(), (Object)oldData, (Object)newData);
            return;
        }
        KmsTenantryDirectCustomerOrgEntity entity = (KmsTenantryDirectCustomerOrgEntity)CrmBeanUtil.copy((Object)reqVo, KmsTenantryDirectCustomerOrgEntity.class);
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        this.save(entity);
        KmsTenantryDirectCustomerOrgRespVo newData = (KmsTenantryDirectCustomerOrgRespVo)CrmBeanUtil.copy((Object)entity, KmsTenantryDirectCustomerOrgRespVo.class);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        this.crmLogSendUtil.sendForAdd(menuCodeObj.toString(), newData.getId(), newData.getBsDirectSystemCode(), (Object)newData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(KmsTenantryDirectCustomerOrgReqVo reqVo) {
        this.checkUpdate(reqVo.getId());
        KmsTenantryDirectCustomerOrgEntity entity = (KmsTenantryDirectCustomerOrgEntity)this.getById((Serializable)((Object)reqVo.getId()));
        KmsTenantryDirectCustomerOrgRespVo oldData = (KmsTenantryDirectCustomerOrgRespVo)CrmBeanUtil.copy((Object)entity, KmsTenantryDirectCustomerOrgRespVo.class);
        BeanUtils.copyProperties((Object)reqVo, (Object)entity);
        this.updateById(entity);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        KmsTenantryDirectCustomerOrgRespVo newData = this.query(entity.getId());
        this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), newData.getId(), newData.getCustomerOrgCode(), (Object)oldData, (Object)newData);
    }

    private void checkUpdate(String id) {
        AssertUtils.isNotEmpty((String)id, (CrmExceptionType)CommonException.IDS_NULL);
        KmsTenantryDirectCustomerOrgEntity entity = (KmsTenantryDirectCustomerOrgEntity)this.kmsTenantryDirectCustomerOrgMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(BaseIdEntity::getId, (Object)id));
        AssertUtils.isNotNull((Object)entity, (String)"\u64cd\u4f5c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List kmsTenantryDirectCustomerOrgEntities = this.kmsTenantryDirectCustomerOrgMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)kmsTenantryDirectCustomerOrgEntities)) {
            kmsTenantryDirectCustomerOrgEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
            this.helper.checkDelete(ids);
        }
        this.updateBatchById(kmsTenantryDirectCustomerOrgEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List kmsTenantryDirectCustomerOrgEntities = this.kmsTenantryDirectCustomerOrgMapper.selectBatchIds(ids);
        List oldDataList = CrmBeanUtil.copyList((List)kmsTenantryDirectCustomerOrgEntities, KmsTenantryDirectCustomerOrgRespVo.class);
        if (CollectionUtils.isNotEmpty((Collection)kmsTenantryDirectCustomerOrgEntities)) {
            kmsTenantryDirectCustomerOrgEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(kmsTenantryDirectCustomerOrgEntities);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        List newDataList = CrmBeanUtil.copyList((List)kmsTenantryDirectCustomerOrgEntities, KmsTenantryDirectCustomerOrgRespVo.class);
        for (int i = 0; i < newDataList.size(); ++i) {
            this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), ((KmsTenantryDirectCustomerOrgRespVo)newDataList.get(i)).getId(), ((KmsTenantryDirectCustomerOrgRespVo)newDataList.get(i)).getBsDirectSystemCode(), newDataList.get(i), oldDataList.get(i));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List kmsTenantryDirectCustomerOrgEntities = this.kmsTenantryDirectCustomerOrgMapper.selectBatchIds(ids);
        List oldDataList = CrmBeanUtil.copyList((List)kmsTenantryDirectCustomerOrgEntities, KmsTenantryDirectCustomerOrgRespVo.class);
        if (CollectionUtils.isNotEmpty((Collection)kmsTenantryDirectCustomerOrgEntities)) {
            kmsTenantryDirectCustomerOrgEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(kmsTenantryDirectCustomerOrgEntities);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        List newDataList = CrmBeanUtil.copyList((List)kmsTenantryDirectCustomerOrgEntities, KmsTenantryDirectCustomerOrgRespVo.class);
        for (int i = 0; i < newDataList.size(); ++i) {
            this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), ((KmsTenantryDirectCustomerOrgRespVo)newDataList.get(i)).getId(), ((KmsTenantryDirectCustomerOrgRespVo)newDataList.get(i)).getBsDirectSystemCode(), newDataList.get(i), oldDataList.get(i));
        }
    }

    @Override
    public List<MdmCustomerOrgSelectRespVo> findCusOrgList(CusOrgVo cusOrgVo) {
        Result cusOrgListResult;
        try {
            cusOrgListResult = this.mdmCusOrgFeign.customerOrgSelect(cusOrgVo);
        }
        catch (Exception e) {
            log.error("{}", (Throwable)e);
            throw new BusinessException(" \u65b0\u589e\u76f4\u8425\u4f53\u7cfb \u83b7\u53d6\u5ba2\u6237\u7ec4\u7ec7\u5217\u8868,\u8c03\u7528mdm\u63a5\u53e3\u5931\u8d25");
        }
        List respVoList = (List)ApiResultUtil.objResult((Result)cusOrgListResult, (boolean)true);
        return respVoList;
    }
}

