/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.supermarket.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectStoreReqVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsTenantryDirectStoreRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.supermarket.mapper.KmsTenantryDirectStoreMapper;
import com.biz.crm.supermarket.model.KmsTenantryDirectStoreEntity;
import com.biz.crm.supermarket.service.IKmsTenantryDirectStoreService;
import com.biz.crm.supermarket.service.impl.KmsTenantryDirectHelper;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.Result;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"KmsTenantryDirectStoreServiceExpandImpl"})
public class KmsTenantryDirectStoreServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<KmsTenantryDirectStoreMapper, KmsTenantryDirectStoreEntity>
implements IKmsTenantryDirectStoreService {
    private static final Logger log = LoggerFactory.getLogger(KmsTenantryDirectStoreServiceImpl.class);
    @Resource
    private KmsTenantryDirectStoreMapper kmsTenantryDirectStoreMapper;
    @Resource
    private KmsTenantryDirectHelper helper;
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;
    @Resource
    private CrmLogSendUtil crmLogSendUtil;

    @Override
    public PageResult<KmsTenantryDirectStoreRespVo> findList(KmsTenantryDirectStoreReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<KmsTenantryDirectStoreRespVo> list = this.kmsTenantryDirectStoreMapper.findList((Page<KmsTenantryDirectStoreRespVo>)page, reqVo);
        if (CollectionUtils.isNotEmpty(list)) {
            this.helper.convertStoreData(list);
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public KmsTenantryDirectStoreRespVo query(String id) {
        AssertUtils.isNotEmpty((String)id, (CrmExceptionType)CommonException.IDS_NULL);
        KmsTenantryDirectStoreReqVo reqVo = new KmsTenantryDirectStoreReqVo();
        reqVo.setId(id);
        List respVos = this.findList(reqVo).getData();
        if (CollectionUtils.isEmpty((Collection)respVos)) {
            throw new BusinessException("\u67e5\u8be2\u6570\u636e\u4e0d\u5b58\u5728");
        }
        return (KmsTenantryDirectStoreRespVo)respVos.get(0);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(KmsTenantryDirectStoreReqVo reqVo) {
        this.helper.checkSaveStoreData(reqVo);
        KmsTenantryDirectStoreEntity entity = (KmsTenantryDirectStoreEntity)CrmBeanUtil.copy((Object)reqVo, KmsTenantryDirectStoreEntity.class);
        this.save(entity);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        KmsTenantryDirectStoreRespVo newData = (KmsTenantryDirectStoreRespVo)CrmBeanUtil.copy((Object)entity, KmsTenantryDirectStoreRespVo.class);
        this.crmLogSendUtil.sendForAdd(menuCodeObj.toString(), newData.getId(), newData.getId(), (Object)newData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(KmsTenantryDirectStoreReqVo reqVo) {
        this.helper.checkStoreUpdate(reqVo);
        this.helper.checkSaveStoreData(reqVo);
        KmsTenantryDirectStoreEntity entity = (KmsTenantryDirectStoreEntity)CrmBeanUtil.copy((Object)reqVo, KmsTenantryDirectStoreEntity.class);
        KmsTenantryDirectStoreRespVo oldData = this.query(reqVo.getId());
        this.kmsTenantryDirectStoreMapper.updateByKey(entity);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        KmsTenantryDirectStoreRespVo newData = this.query(reqVo.getId());
        this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), newData.getId(), newData.getId(), (Object)oldData, (Object)newData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List kmsTenantryDirectStoreEntities = this.kmsTenantryDirectStoreMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)kmsTenantryDirectStoreEntities)) {
            kmsTenantryDirectStoreEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(kmsTenantryDirectStoreEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List kmsTenantryDirectStoreEntities = this.kmsTenantryDirectStoreMapper.selectBatchIds(ids);
        List oldDataList = CrmBeanUtil.copyList((List)kmsTenantryDirectStoreEntities, KmsTenantryDirectStoreRespVo.class);
        if (CollectionUtils.isNotEmpty((Collection)kmsTenantryDirectStoreEntities)) {
            kmsTenantryDirectStoreEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(kmsTenantryDirectStoreEntities);
        Object menuCode = ThreadLocalUtil.getObj((String)"menuCode");
        List newDataList = CrmBeanUtil.copyList((List)kmsTenantryDirectStoreEntities, KmsTenantryDirectStoreRespVo.class);
        for (int i = 0; i < newDataList.size(); ++i) {
            this.crmLogSendUtil.sendForUpdate(menuCode.toString(), ((KmsTenantryDirectStoreRespVo)newDataList.get(i)).getId(), ((KmsTenantryDirectStoreRespVo)newDataList.get(i)).getId(), oldDataList.get(i), newDataList.get(i));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List kmsTenantryDirectStoreEntities = this.kmsTenantryDirectStoreMapper.selectBatchIds(ids);
        List oldDataList = CrmBeanUtil.copyList((List)kmsTenantryDirectStoreEntities, KmsTenantryDirectStoreRespVo.class);
        if (CollectionUtils.isNotEmpty((Collection)kmsTenantryDirectStoreEntities)) {
            kmsTenantryDirectStoreEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(kmsTenantryDirectStoreEntities);
        Object menuCode = ThreadLocalUtil.getObj((String)"menuCode");
        List newDataList = CrmBeanUtil.copyList((List)kmsTenantryDirectStoreEntities, KmsTenantryDirectStoreRespVo.class);
        for (int i = 0; i < newDataList.size(); ++i) {
            this.crmLogSendUtil.sendForUpdate(menuCode.toString(), ((KmsTenantryDirectStoreRespVo)newDataList.get(i)).getId(), ((KmsTenantryDirectStoreRespVo)newDataList.get(i)).getId(), oldDataList.get(i), newDataList.get(i));
        }
    }

    @Override
    public List<MdmTerminalVo> findTerminalList(MdmTerminalVo mdmTerminalVo) {
        Result listResult;
        mdmTerminalVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        mdmTerminalVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        try {
            listResult = this.mdmTerminalFeign.listCondition(mdmTerminalVo);
        }
        catch (Exception e) {
            log.error("{}", (Throwable)e);
            throw new BusinessException(" \u65b0\u589e\u4f01\u4e1a\u95e8\u5e97\u4e0e\u5546\u8d85\u95e8\u5e97\u5173\u7cfb \u83b7\u53d6\u95e8\u5e97\u5217\u8868,\u8c03\u7528mdm\u63a5\u53e3\u5931\u8d25");
        }
        return (List)ApiResultUtil.objResult((Result)listResult, (boolean)true);
    }
}

