/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.supermarket.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.confadmin.mapper.KmsDirectStoreMapper;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.kaproduct.mapper.KmsTenantryDirectProductMapper;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.kms.kaproduct.resp.KmsTenantryDirectProductRespVo;
import com.biz.crm.nebular.kms.supermarket.req.KmsTotalWarehouseStoreReqVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsTenantryDirectStoreRespVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsTotalWarehouseStoreRespVo;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.supermarket.mapper.KmsTenantryDirectCustomerOrgMapper;
import com.biz.crm.supermarket.mapper.KmsTotalWarehouseStoreMapper;
import com.biz.crm.supermarket.model.KmsTotalWarehouseStoreEntity;
import com.biz.crm.supermarket.service.IKmsTotalWarehouseStoreService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.KmsOrgUtil;
import com.biz.crm.util.PageUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"KmsTotalWarehouseStoreServiceExpandImpl"})
public class KmsTotalWarehouseStoreServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<KmsTotalWarehouseStoreMapper, KmsTotalWarehouseStoreEntity>
implements IKmsTotalWarehouseStoreService {
    private static final Logger log = LoggerFactory.getLogger(KmsTotalWarehouseStoreServiceImpl.class);
    @Resource
    private KmsTotalWarehouseStoreMapper kmsTotalWarehouseStoreMapper;
    @Resource
    private KmsTenantryDirectCustomerOrgMapper kmsTenantryDirectCustomerOrgMapper;
    @Resource
    private KmsDirectStoreMapper kmsDirectStoreMapper;
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;
    @Resource
    private KmsTenantryDirectProductMapper kmsTenantryDirectProductMapper;
    @Resource
    private CrmLogSendUtil crmLogSendUtil;

    public Map<String, Map<String, String>> getDictMaps() {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("kms_product_type");
        dictCodes.add("enable_status");
        return DictUtil.getDictValueMapsByCodes((List)dictCodes);
    }

    @Override
    public PageResult<KmsTotalWarehouseStoreRespVo> findList(KmsTotalWarehouseStoreReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<KmsTotalWarehouseStoreRespVo> list = this.kmsTotalWarehouseStoreMapper.findList((Page<KmsTotalWarehouseStoreRespVo>)page, reqVo);
        if (CollectionUtils.isNotEmpty(list)) {
            this.convertData(list);
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    private void convertData(List<KmsTotalWarehouseStoreRespVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List<String> createOrgCodes = list.stream().map(CrmBaseVo::getCreateOrgCode).distinct().collect(Collectors.toList());
        Map<String, String> orgCompanyMap = KmsOrgUtil.findCompanyByCreateOrgCodes(createOrgCodes);
        Map<String, Map<String, String>> dataMap = this.getDictMaps();
        list.forEach(x -> {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)x.getProductType())) {
                x.setProductTypeDesc((String)((Map)Optional.ofNullable(dataMap.get("kms_product_type")).orElse(Maps.newHashMap())).get(x.getProductType()));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)x.getEnableStatus())) {
                x.setEnableStatusName((String)((Map)Optional.ofNullable(dataMap.get("enable_status")).orElse(Maps.newHashMap())).get(x.getEnableStatus()));
            }
            x.setOwnedCompany((String)orgCompanyMap.get(x.getCreateOrgCode()));
        });
    }

    @Override
    public KmsTotalWarehouseStoreRespVo query(String id) {
        AssertUtils.isNotEmpty((String)id, (String)"\u8bf7\u9009\u62e9\u64cd\u4f5c\u6570\u636e");
        KmsTotalWarehouseStoreReqVo reqVo = new KmsTotalWarehouseStoreReqVo();
        reqVo.setId(id);
        List respVos = this.findList(reqVo).getData();
        if (CollectionUtils.isEmpty((Collection)respVos)) {
            return null;
        }
        KmsTotalWarehouseStoreRespVo kmsTotalWarehouseStoreRespVo = (KmsTotalWarehouseStoreRespVo)respVos.get(0);
        if (!StringUtils.isEmpty((Object)kmsTotalWarehouseStoreRespVo.getDirectProductId())) {
            KmsTenantryDirectProductRespVo productRespVo = this.kmsTenantryDirectProductMapper.findById(kmsTotalWarehouseStoreRespVo.getDirectProductId());
            ArrayList productRespVos = Lists.newArrayList();
            productRespVos.add(productRespVo);
            kmsTotalWarehouseStoreRespVo.setDirectProductReqVos((List)productRespVos);
        }
        return kmsTotalWarehouseStoreRespVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(KmsTotalWarehouseStoreReqVo reqVo) {
        this.checkNotEmpty(reqVo);
        this.checkDataExist(reqVo);
        List<KmsTotalWarehouseStoreEntity> entities = this.convert(reqVo);
        this.saveBatch(entities);
        List newDataList = CrmBeanUtil.copyList(entities, KmsTenantryDirectStoreRespVo.class);
        Object menuCode = ThreadLocalUtil.getObj((String)"menuCode");
        for (int i = 0; i < newDataList.size(); ++i) {
            this.crmLogSendUtil.sendForAdd(menuCode.toString(), ((KmsTenantryDirectStoreRespVo)newDataList.get(i)).getId(), ((KmsTenantryDirectStoreRespVo)newDataList.get(i)).getId(), newDataList.get(i));
        }
    }

    private void checkDataExist(KmsTotalWarehouseStoreReqVo reqVo) {
        KmsTotalWarehouseStoreReqVo selectReqVo = new KmsTotalWarehouseStoreReqVo();
        selectReqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        selectReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        selectReqVo.setBsDirectSystemId(reqVo.getBsDirectSystemId());
        selectReqVo.setTerminalCode(reqVo.getTerminalCode());
        selectReqVo.setProductType(reqVo.getProductType());
        List<KmsTotalWarehouseStoreEntity> entities = this.kmsTotalWarehouseStoreMapper.selectListWithDataPurview(selectReqVo);
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)entities.get(0).getProductCode())) {
            throw new BusinessException("\u6570\u636e\u5df2\u5b58\u5728");
        }
        if (CollectionUtils.isNotEmpty((Collection)reqVo.getDirectProductReqVos())) {
            Set productCodeSet = entities.stream().map(KmsTotalWarehouseStoreEntity::getProductCode).collect(Collectors.toSet());
            HashSet productExistSet = Sets.newHashSet();
            reqVo.getDirectProductReqVos().forEach(x -> {
                if (productCodeSet.contains(x.getProductCode())) {
                    productExistSet.add(x.getProductCode());
                }
            });
            if (CollectionUtils.isNotEmpty((Collection)productExistSet)) {
                throw new BusinessException(((Object)productExistSet).toString() + "\u7684\u7269\u6599\u4ee5\u7ef4\u62a4");
            }
        }
        if (CollectionUtils.isEmpty((Collection)reqVo.getDirectProductReqVos())) {
            throw new BusinessException("\u6570\u636e\u5df2\u5b58\u5728");
        }
    }

    private void checkDataExistAndSave(List<KmsTotalWarehouseStoreEntity> entities) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(KmsTotalWarehouseStoreReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"\u8bf7\u9009\u62e9\u64cd\u4f5c\u6570\u636e");
        this.checkNotEmpty(reqVo);
        KmsTotalWarehouseStoreEntity entityByDb = (KmsTotalWarehouseStoreEntity)this.kmsTotalWarehouseStoreMapper.selectById((Serializable)((Object)reqVo.getId()));
        KmsTotalWarehouseStoreRespVo oldData = (KmsTotalWarehouseStoreRespVo)CrmBeanUtil.copy((Object)entityByDb, KmsTotalWarehouseStoreRespVo.class);
        AssertUtils.isNotNull((Object)entityByDb, (String)"\u4fee\u6539\u6570\u636e\u4e0d\u5b58\u5728");
        BeanUtils.copyProperties((Object)reqVo, (Object)entityByDb);
        this.updateById(entityByDb);
        KmsTotalWarehouseStoreRespVo newData = this.query(reqVo.getId());
        Object menuCode = ThreadLocalUtil.getObj((String)"menuCode");
        this.crmLogSendUtil.sendForUpdate(menuCode.toString(), newData.getId(), newData.getId(), (Object)oldData, (Object)newData);
    }

    private void checkNotEmpty(KmsTotalWarehouseStoreReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getBsDirectSystemId(), (String)"\u76f4\u8425\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getBsDirectSystemCode(), (String)"\u76f4\u8425\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getDirectStoreId(), (String)"\u76f4\u8425\u95e8\u5e97ID\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getTerminalCode(), (String)"\u4f01\u4e1a\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getTerminalName(), (String)"\u4f01\u4e1a\u95e8\u5e97\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private List<KmsTotalWarehouseStoreEntity> convert(KmsTotalWarehouseStoreReqVo reqVo) {
        ArrayList entities = Lists.newArrayList();
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)reqVo.getDirectProductReqVos())) {
            entities.add(CrmBeanUtil.copy((Object)reqVo, KmsTotalWarehouseStoreEntity.class));
        } else {
            reqVo.getDirectProductReqVos().forEach(o -> {
                KmsTotalWarehouseStoreEntity entity = (KmsTotalWarehouseStoreEntity)CrmBeanUtil.copy((Object)reqVo, KmsTotalWarehouseStoreEntity.class);
                entity.setDirectProductId(o.getId());
                entity.setProductCode(o.getProductCode());
                entity.setProductName(o.getProductName());
                entity.setKaProductCode(o.getKaProductCode());
                entities.add(entity);
            });
        }
        return entities;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List kmsTotalWarehouseStoreEntities = this.kmsTotalWarehouseStoreMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)kmsTotalWarehouseStoreEntities)) {
            kmsTotalWarehouseStoreEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(kmsTotalWarehouseStoreEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List kmsTotalWarehouseStoreEntities = this.kmsTotalWarehouseStoreMapper.selectBatchIds(ids);
        List oldDataList = CrmBeanUtil.copyList((List)kmsTotalWarehouseStoreEntities, KmsTotalWarehouseStoreRespVo.class);
        if (CollectionUtils.isNotEmpty((Collection)kmsTotalWarehouseStoreEntities)) {
            kmsTotalWarehouseStoreEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        List newDataList = CrmBeanUtil.copyList((List)kmsTotalWarehouseStoreEntities, KmsTotalWarehouseStoreRespVo.class);
        this.updateBatchById(kmsTotalWarehouseStoreEntities);
        Object menuCode = ThreadLocalUtil.getObj((String)"menuCode");
        for (int i = 0; i < newDataList.size(); ++i) {
            this.crmLogSendUtil.sendForUpdate(menuCode.toString(), ((KmsTotalWarehouseStoreRespVo)newDataList.get(i)).getId(), ((KmsTotalWarehouseStoreRespVo)newDataList.get(i)).getId(), oldDataList.get(i), newDataList.get(i));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List kmsTotalWarehouseStoreEntities = this.kmsTotalWarehouseStoreMapper.selectBatchIds(ids);
        List oldDataList = CrmBeanUtil.copyList((List)kmsTotalWarehouseStoreEntities, KmsTotalWarehouseStoreRespVo.class);
        if (CollectionUtils.isNotEmpty((Collection)kmsTotalWarehouseStoreEntities)) {
            kmsTotalWarehouseStoreEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        List newDataList = CrmBeanUtil.copyList((List)kmsTotalWarehouseStoreEntities, KmsTotalWarehouseStoreRespVo.class);
        this.updateBatchById(kmsTotalWarehouseStoreEntities);
        Object menuCode = ThreadLocalUtil.getObj((String)"menuCode");
        for (int i = 0; i < newDataList.size(); ++i) {
            this.crmLogSendUtil.sendForUpdate(menuCode.toString(), ((KmsTotalWarehouseStoreRespVo)newDataList.get(i)).getId(), ((KmsTotalWarehouseStoreRespVo)newDataList.get(i)).getId(), oldDataList.get(i), newDataList.get(i));
        }
    }
}

