/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.base.BusinessException;
import com.biz.crm.config.KmsSapConfig;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JDBCUtils {
    private static final Logger log = LoggerFactory.getLogger(JDBCUtils.class);
    private static String drivername = "com.sap.db.jdbc.Driver";
    @Resource
    private KmsSapConfig kmsSapConfig;
    private static final JDBCUtils instance = new JDBCUtils();

    @PostConstruct
    public void init() {
        JDBCUtils.instance.kmsSapConfig = this.kmsSapConfig;
    }

    public static Connection getConnection() {
        Connection con = null;
        try {
            con = DriverManager.getConnection(JDBCUtils.instance.kmsSapConfig.getSapHanaAddr(), JDBCUtils.instance.kmsSapConfig.getSapHanaUserName(), JDBCUtils.instance.kmsSapConfig.getSapHanaPassWord());
        }
        catch (SQLException e) {
            log.info("hana\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38:{}", (Object)e.getMessage());
            throw new BusinessException("hana\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38\uff0c" + e.getMessage());
        }
        return con;
    }

    public static void closeResource(Connection con, Statement sta, ResultSet rs) {
        try {
            if (con != null) {
                con.close();
            }
            if (sta != null) {
                sta.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            log.info("\u5173\u95ed\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
    }
}

