/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.constant.KmsConstant;
import com.biz.crm.eunm.kms.KmsAdminEnum;
import com.biz.crm.eunm.kms.KmsAuditConditionEnum;
import com.biz.crm.eunm.kms.KmsEnum;
import com.biz.crm.finance.model.KmsAcceptanceMatchRelationEntity;
import com.biz.crm.finance.model.KmsAuditFormEntity;
import com.biz.crm.nebular.kms.acceptanceform.resp.KmsAuditAcceptanceFormRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditFormRespVo;
import com.biz.crm.nebular.kms.finance.resp.KmsAuditTemplateRespVo;
import com.biz.crm.util.DateUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class KmsUtils {
    public static String removeFrontZero(String str) {
        return str.replaceAll("^(0+)", "");
    }

    public static String[] ignoreProperties() {
        List<String> collect = Arrays.stream(CrmBaseEntity.class.getDeclaredFields()).map(Field::getName).collect(Collectors.toList());
        collect.add("id");
        String[] ignoreProperties = collect.toArray(new String[0]);
        return ignoreProperties;
    }

    public static String addZero(String str, int flag) {
        int length = str.length();
        String zero = "";
        int j = flag - length;
        for (int i = 0; i < j; ++i) {
            zero = zero + "0";
        }
        str = zero + str;
        return str;
    }

    public static KmsAuditConditionEnum getConditionEnum(KmsAuditTemplateRespVo templateRespVo) {
        ArrayList stp = Lists.newArrayList();
        stp.add(KmsAdminEnum.AuditCondition.STORE_CODE.getValue());
        stp.add(KmsAdminEnum.AuditCondition.ORDER_TIME.getValue());
        stp.add(KmsAdminEnum.AuditCondition.GOODS_CODE.getValue());
        String aconStp = stp.stream().sorted().collect(Collectors.joining(","));
        if (aconStp.equals(templateRespVo.getConditionArray())) {
            return KmsAuditConditionEnum.PDS;
        }
        stp = Lists.newArrayList();
        stp.add(KmsAdminEnum.AuditCondition.STORE_CODE.getValue());
        stp.add(KmsAdminEnum.AuditCondition.GOODS_CODE.getValue());
        stp.add(KmsAdminEnum.AuditCondition.ORDER_CODE.getValue());
        aconStp = stp.stream().sorted().collect(Collectors.joining(","));
        if (aconStp.equals(templateRespVo.getConditionArray())) {
            return KmsAuditConditionEnum.PDSO;
        }
        stp = Lists.newArrayList();
        stp.add(KmsAdminEnum.AuditCondition.STORE_CODE.getValue());
        stp.add(KmsAdminEnum.AuditCondition.ORDER_TIME.getValue());
        aconStp = stp.stream().sorted().collect(Collectors.joining(","));
        if (aconStp.equals(templateRespVo.getConditionArray())) {
            return KmsAuditConditionEnum.DS;
        }
        stp = Lists.newArrayList();
        stp.add(KmsAdminEnum.AuditCondition.STORE_CODE.getValue());
        stp.add(KmsAdminEnum.AuditCondition.ORDER_CODE.getValue());
        aconStp = stp.stream().sorted().collect(Collectors.joining(","));
        if (aconStp.equals(templateRespVo.getConditionArray())) {
            return KmsAuditConditionEnum.PDSO;
        }
        return null;
    }

    public static String getOrderTypeConEnum(KmsAuditTemplateRespVo templateRespVo) {
        ArrayList stp = Lists.newArrayList();
        stp.add(KmsAdminEnum.OrderType.ACCEPTANCE.getValue());
        String aconStp = stp.stream().sorted().collect(Collectors.joining(","));
        if (aconStp.equals(templateRespVo.getOrderTypeArray())) {
            return KmsEnum.AuditOrderType.ACCEPTANCE.getValue();
        }
        stp = Lists.newArrayList();
        stp.add(KmsAdminEnum.OrderType.ORDER.getValue());
        stp.add(KmsAdminEnum.OrderType.ACCEPTANCE.getValue());
        aconStp = stp.stream().sorted().collect(Collectors.joining(","));
        if (aconStp.equals(templateRespVo.getOrderTypeArray())) {
            return KmsEnum.AuditOrderType.ORDER_ACCEPTANCE.getValue();
        }
        return null;
    }

    public static void acceptanceAmountHandle(KmsAuditAcceptanceFormRespVo a, BigDecimal taxRate) {
        BigDecimal acceptanceAmount = BigDecimal.ZERO;
        BigDecimal acceptanceAmountNot = BigDecimal.ZERO;
        if (!(StringUtils.isEmpty((Object)a.getAcceptanceAmount()) || !StringUtils.isEmpty((Object)a.getAcceptanceAmountNot()) && new BigDecimal(a.getAcceptanceAmountNot()).compareTo(BigDecimal.ZERO) != 0 || ObjectUtils.isEmpty((Object)taxRate))) {
            acceptanceAmount = new BigDecimal(a.getAcceptanceAmount());
            acceptanceAmountNot = acceptanceAmount.divide(taxRate, 6, 4);
        } else if (!(!StringUtils.isEmpty((Object)a.getAcceptanceAmount()) && new BigDecimal(a.getAcceptanceAmount()).compareTo(BigDecimal.ZERO) != 0 || StringUtils.isEmpty((Object)a.getAcceptanceAmountNot()) || ObjectUtils.isEmpty((Object)taxRate))) {
            acceptanceAmountNot = new BigDecimal(a.getAcceptanceAmountNot());
            acceptanceAmount = acceptanceAmountNot.multiply(taxRate);
        } else if (!StringUtils.isEmpty((Object)a.getAcceptanceAmount()) && !StringUtils.isEmpty((Object)a.getAcceptanceAmountNot())) {
            acceptanceAmount = new BigDecimal(a.getAcceptanceAmount());
            acceptanceAmountNot = new BigDecimal(a.getAcceptanceAmountNot());
        }
        a.setAcceptanceAmount(acceptanceAmount.toString());
        a.setAcceptanceAmountNot(acceptanceAmountNot.toString());
        BigDecimal acceptanceQuantity = StringUtils.isEmpty((Object)a.getAcceptanceQuantity()) ? BigDecimal.ZERO : new BigDecimal(a.getAcceptanceQuantity());
        a.setAcceptanceQuantity(acceptanceQuantity.toString());
    }

    public static KmsAcceptanceMatchRelationEntity buildAcceptanceMatchRelation(KmsAuditAcceptanceFormRespVo o, KmsAuditFormRespVo afVo, String templateId) {
        KmsAcceptanceMatchRelationEntity relationEntity = new KmsAcceptanceMatchRelationEntity();
        relationEntity.setAuditId(afVo.getId());
        relationEntity.setAuditNumber(afVo.getAuditNumber());
        relationEntity.setAuditTemplateId(templateId);
        relationEntity.setHeaderId(o.getHeaderId());
        relationEntity.setRelationId(o.getId());
        return relationEntity;
    }

    public static void sapInvoiceData(KmsAuditFormRespVo o) {
        o.setSapAmount(BigDecimal.ZERO);
        o.setSapAmountNot(BigDecimal.ZERO);
        o.setSapQuantity(BigDecimal.ZERO);
        o.setAcceptanceAmount(BigDecimal.ZERO);
        o.setAcceptanceAmountNot(BigDecimal.ZERO);
        o.setAcceptanceQuantity(BigDecimal.ZERO);
        o.setCompareAmount(BigDecimal.ZERO);
        o.setCompareAmountNot(BigDecimal.ZERO);
        o.setCompareQuantity(BigDecimal.ZERO);
        HashMap taxRateMap = Maps.newHashMap();
        o.getSapOrderFormVos().forEach(s -> {
            s.setSapAmount(s.getKzwi1().add(s.getYk11()).add(s.getZst2()));
            o.setSapAmount(o.getSapAmount().add(s.getSapAmount()));
            BigDecimal numerator = s.getYk11().add(s.getZst2());
            BigDecimal denominator = BigDecimal.ONE.add(s.getMwsi1().divide(KmsConstant.BASE_1000));
            s.setSapAmountNot(s.getNetwr().add(numerator.divide(denominator, 6, 4)));
            o.setSapAmountNot(o.getSapAmountNot().add(s.getSapAmountNot()));
            s.setSapMaterielCode(KmsUtils.removeFrontZero(s.getSapMaterielCode()));
            taxRateMap.put(s.getSapMaterielCode(), denominator);
            o.setSapQuantity(o.getSapQuantity().add(s.getSapQuantity()));
            s.setDanjia(s.getSapAmount().divide(s.getSapQuantity(), 2, 4));
        });
        if (!ObjectUtils.isEmpty((Object)o.getSapQuantity()) && o.getSapQuantity().compareTo(BigDecimal.ZERO) != 0) {
            o.setDanjia(o.getSapAmount().divide(o.getSapQuantity(), 2, 4));
        }
        BigDecimal sub = BigDecimal.ZERO;
        BigDecimal subNot = BigDecimal.ZERO;
        BigDecimal subQuantity = BigDecimal.ZERO;
        if (CollectionUtils.isEmpty((Collection)o.getAcceptanceFormVos())) {
            o.setAuditResult(KmsEnum.AuditResult.WAIT.getValue());
            o.setAuditStatus(KmsEnum.AuditStatus.WAIT.getValue());
            sub = o.getAcceptanceAmount().subtract(o.getSapAmount());
            subNot = o.getAcceptanceAmountNot().subtract(o.getSapAmountNot());
            subQuantity = o.getAcceptanceQuantity().subtract(o.getSapQuantity());
        } else {
            o.getAcceptanceFormVos().forEach(acc -> {
                BigDecimal taxRate = (BigDecimal)taxRateMap.get(acc.getGoodsCode());
                KmsUtils.acceptanceAmountHandle(acc, taxRate);
                o.setAcceptanceQuantity(o.getAcceptanceQuantity().add(new BigDecimal(acc.getAcceptanceQuantity())));
                o.setAcceptanceAmount(o.getAcceptanceAmount().add(new BigDecimal(acc.getAcceptanceAmount())));
                o.setAcceptanceAmountNot(o.getAcceptanceAmountNot().add(new BigDecimal(acc.getAcceptanceAmountNot())));
            });
            String auditRule = o.getAuditRule();
            BigDecimal differencePrice = o.getDifferencePrice();
            sub = o.getAcceptanceAmount().subtract(o.getSapAmount());
            BigDecimal priceDiff = sub.multiply(new BigDecimal(-1));
            subNot = o.getAcceptanceAmountNot().subtract(o.getSapAmountNot());
            subQuantity = o.getAcceptanceQuantity().subtract(o.getSapQuantity());
            if (subQuantity.compareTo(BigDecimal.ZERO) != 0) {
                if (KmsEnum.AuditRule.Z.getValue().equals(auditRule)) {
                    if (priceDiff.compareTo(BigDecimal.ZERO) >= 0 && priceDiff.compareTo(differencePrice) <= 0) {
                        o.setAuditResult(KmsEnum.AuditResult.NO_DIFFERENCE.getValue());
                    } else {
                        o.setAuditResult(KmsEnum.AuditResult.PRICE_QUANTITY_DIFF.getValue());
                    }
                } else if (KmsEnum.AuditRule.F.getValue().equals(auditRule)) {
                    if (priceDiff.compareTo(BigDecimal.ZERO) <= 0 && priceDiff.compareTo(differencePrice.multiply(new BigDecimal(-1))) >= 0) {
                        o.setAuditResult(KmsEnum.AuditResult.NO_DIFFERENCE.getValue());
                    } else {
                        o.setAuditResult(KmsEnum.AuditResult.PRICE_QUANTITY_DIFF.getValue());
                    }
                } else if (KmsEnum.AuditRule.UD.getValue().equals(auditRule)) {
                    if (priceDiff.compareTo(BigDecimal.ZERO) >= 0 && priceDiff.compareTo(differencePrice) <= 0 || priceDiff.compareTo(BigDecimal.ZERO) <= 0 && priceDiff.compareTo(differencePrice.multiply(new BigDecimal(-1))) >= 0) {
                        o.setAuditResult(KmsEnum.AuditResult.NO_DIFFERENCE.getValue());
                    } else {
                        o.setAuditResult(KmsEnum.AuditResult.PRICE_QUANTITY_DIFF.getValue());
                    }
                }
                if (KmsEnum.AuditResult.NO_DIFFERENCE.getValue().equals(o.getAuditResult())) {
                    o.setAuditResult(KmsEnum.AuditResult.QUANTITY_DIFF.getValue());
                }
            } else if (KmsEnum.AuditRule.Z.getValue().equals(auditRule)) {
                if (priceDiff.compareTo(BigDecimal.ZERO) >= 0 && priceDiff.compareTo(differencePrice) <= 0) {
                    o.setAuditResult(KmsEnum.AuditResult.NO_DIFFERENCE.getValue());
                } else {
                    o.setAuditResult(KmsEnum.AuditResult.PRICE_DIFF.getValue());
                }
            } else if (KmsEnum.AuditRule.F.getValue().equals(auditRule)) {
                if (priceDiff.compareTo(BigDecimal.ZERO) <= 0 && priceDiff.compareTo(differencePrice.multiply(new BigDecimal(-1))) >= 0) {
                    o.setAuditResult(KmsEnum.AuditResult.NO_DIFFERENCE.getValue());
                } else {
                    o.setAuditResult(KmsEnum.AuditResult.PRICE_DIFF.getValue());
                }
            } else if (KmsEnum.AuditRule.UD.getValue().equals(auditRule)) {
                if (priceDiff.compareTo(BigDecimal.ZERO) >= 0 && priceDiff.compareTo(differencePrice) <= 0 || priceDiff.compareTo(BigDecimal.ZERO) <= 0 && priceDiff.compareTo(differencePrice.multiply(new BigDecimal(-1))) >= 0) {
                    o.setAuditResult(KmsEnum.AuditResult.NO_DIFFERENCE.getValue());
                } else {
                    o.setAuditResult(KmsEnum.AuditResult.PRICE_DIFF.getValue());
                }
            }
        }
        o.setCompareAmount(ObjectUtils.isEmpty((Object)sub) ? BigDecimal.ZERO : sub);
        o.setCompareAmountNot(ObjectUtils.isEmpty((Object)subNot) ? BigDecimal.ZERO : subNot);
        o.setCompareQuantity(ObjectUtils.isEmpty((Object)subQuantity) ? BigDecimal.ZERO : subQuantity);
    }

    public static void setScaleTwo(KmsAuditFormRespVo o) {
        if (!ObjectUtils.isEmpty((Object)o.getAcceptanceAmountNot())) {
            o.setAcceptanceAmountNot(o.getAcceptanceAmountNot().setScale(2, 4));
        }
        if (!ObjectUtils.isEmpty((Object)o.getAcceptanceAmount())) {
            o.setAcceptanceAmount(o.getAcceptanceAmount().setScale(2, 4));
        }
        if (!ObjectUtils.isEmpty((Object)o.getSapAmount())) {
            o.setSapAmount(o.getSapAmount().setScale(2, 4));
        }
        if (!ObjectUtils.isEmpty((Object)o.getSapAmountNot())) {
            o.setSapAmountNot(o.getSapAmountNot().setScale(2, 4));
        }
        if (!ObjectUtils.isEmpty((Object)o.getCompareAmount())) {
            o.setCompareAmount(o.getCompareAmount().setScale(2, 4));
        }
        if (!ObjectUtils.isEmpty((Object)o.getCompareAmountNot())) {
            o.setCompareAmountNot(o.getCompareAmountNot().setScale(2, 4));
        }
        if (!CollectionUtils.isEmpty((Collection)o.getSapOrderFormVos())) {
            o.getSapOrderFormVos().forEach(s -> {
                if (!ObjectUtils.isEmpty((Object)s.getSapAmount())) {
                    s.setSapAmount(s.getSapAmount().setScale(2, 4));
                }
                if (!ObjectUtils.isEmpty((Object)s.getSapAmountNot())) {
                    s.setSapAmountNot(s.getSapAmountNot().setScale(2, 4));
                }
            });
        }
        if (!CollectionUtils.isEmpty((Collection)o.getAcceptanceFormVos())) {
            o.getAcceptanceFormVos().forEach(a -> {
                a.setAcceptanceAmount(new BigDecimal(a.getAcceptanceAmount()).setScale(2, 4).toString());
                a.setAcceptanceAmountNot(new BigDecimal(a.getAcceptanceAmountNot()).setScale(2, 4).toString());
            });
        }
    }

    public static void updateAuditFormData(KmsAuditFormRespVo afVo, KmsAuditFormEntity auditFormEntity) {
        auditFormEntity.setSapAmount(afVo.getSapAmount().toString());
        auditFormEntity.setSapAmountNot(afVo.getSapAmountNot().toString());
        auditFormEntity.setSapQuantity(afVo.getSapQuantity().toString());
        auditFormEntity.setAcceptanceAmount(afVo.getAcceptanceAmount().toString());
        auditFormEntity.setAcceptanceAmountNot(afVo.getAcceptanceAmountNot().toString());
        auditFormEntity.setAcceptanceQuantity(afVo.getAcceptanceQuantity().toString());
        auditFormEntity.setCompareAmount(afVo.getCompareAmount().toString());
        auditFormEntity.setCompareAmountNot(afVo.getCompareAmountNot().toString());
        auditFormEntity.setCompareQuantity(afVo.getCompareQuantity().toString());
        auditFormEntity.setAuditResult(afVo.getAuditResult());
    }

    public static String formatYYYYMMDD(String auditDate) {
        Date dateByFormat = DateUtil.getDateByFormat((String)auditDate, (String)"yyyy-MM-dd");
        return DateUtil.format((Date)dateByFormat, (String)"yyyyMMdd");
    }

    public static String errorString(StackTraceElement[] stackTraceElements, String filtration) {
        if (null == stackTraceElements || stackTraceElements.length < 1) {
            return null;
        }
        StringBuffer upMethodName = new StringBuffer();
        for (StackTraceElement stackTraceElement : stackTraceElements) {
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)filtration) && !stackTraceElement.getClassName().startsWith(filtration)) continue;
            upMethodName.append("\n\t res ");
            upMethodName.append(stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + "(" + stackTraceElement.getFileName() + ":" + stackTraceElement.getLineNumber() + ")");
        }
        return upMethodName.toString();
    }
}

