package com.biz.crm.log.util;

import com.biz.crm.log.entity.CrmLogEntity;
import com.biz.crm.nebular.log.CrmLogDto;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.UUIDGenerator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/12/17 16:03
 **/
public class CrmLogUtil {

    /**
     * 组装新增的对象
     * @param crmLogDto
     * @return
     */
    public static List<CrmLogEntity> vo2EntityForAdd(CrmLogDto crmLogDto){
        List<CrmLogEntity> reList = null;
        Object newObject = crmLogDto.getNewObject();
        if(newObject instanceof Collection){
            List<Object> newObjects = (List<Object>) newObject;
            reList = new ArrayList<>(newObjects.size());
            for(Object object : newObjects){
                CrmLogEntity entity = newCommonFieldInstance(crmLogDto);
                entity.setNewObject(object);
                reList.add(entity);
            }
            return reList;
        }else {
            reList = new ArrayList<>(1);
            CrmLogEntity entity = newCommonFieldInstance(crmLogDto);
            entity.setNewObject(newObject);
            reList.add(entity);
            return reList;
        }
    }


    /**
     * 组装删除的对象
     * @param crmLogDto
     * @return
     */
    public static List<CrmLogEntity> vo2EntityForDel(CrmLogDto crmLogDto){
        List<CrmLogEntity> reList = null;
        Object oldObject = crmLogDto.getOldObject();
        if(oldObject instanceof Collection){
            List<Object> oldObjects = (List<Object>) oldObject;
            reList = new ArrayList<>(oldObjects.size());
            for(Object object : oldObjects){
                CrmLogEntity entity = newCommonFieldInstance(crmLogDto);
                entity.setOldObject(oldObject);
                reList.add(entity);
            }
            return reList;
        }else {
            reList = new ArrayList<>(1);
            CrmLogEntity entity = newCommonFieldInstance(crmLogDto);
            entity.setOldObject(oldObject);
            reList.add(entity);
            return reList;
        }
    }


    /**
     * 组装修改的对象
     * @param crmLogDto
     * @param result 对比结果
     * @return
     */
    public static CrmLogEntity vo2EntityForUpdate(CrmLogDto crmLogDto, Object result){
        CrmLogEntity entity = newCommonFieldInstance(crmLogDto);
        entity.setOnlyKey(crmLogDto.getOnlyKey());
        entity.setOldObject(crmLogDto.getOldObject());
        entity.setNewObject(crmLogDto.getNewObject());
        entity.setCompareResult(result);
        return entity;
    }

    /**
     * 精简代码，设置公共字段
     * @param crmLogDto
     * @return
     */
    public static CrmLogEntity newCommonFieldInstance(CrmLogDto crmLogDto){
        CrmLogEntity entity = new CrmLogEntity();
        entity.setId(UUIDGenerator.generate());
        entity.setOperationType(crmLogDto.getOperationType());
        entity.setOnlyKeyDes(crmLogDto.getOnlyKeyDes());
        entity.setModularCode(crmLogDto.getModularCode());
        entity.setOperationUserId(crmLogDto.getOperationUserId());
        entity.setOperationUserName(crmLogDto.getOperationUserName());
        entity.setOperationTime(crmLogDto.getOperationTime());
        entity.setOperationTimeNum(DateUtil.str2Date(entity.getOperationTime(),DateUtil.datetimeFormat).getTime());
        return entity;
    }
}
