/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.log.handle.util;

import com.alibaba.fastjson.JSON;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.log.LogEunm;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.log.CrmLogDto;
import com.biz.crm.util.DateUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class CrmLogSendUtil {
    @Autowired
    private RocketMQProducer rocketMQProducer;

    public void sendForUpdate(String templateCode, String onlyKey, String modularCode, Object oldObject, Object newObject, String operationUserId, String operationUserName) {
        if (null == oldObject || null == newObject) {
            throw new BusinessException("\u66f4\u65b0\u65e5\u5fd7\u6bd4\u5bf9\u524d/\u540e\u503c\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)modularCode)) {
            throw new BusinessException("\u6a21\u5757\u7f16\u7801\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)templateCode)) {
            throw new BusinessException("\u65e5\u5fd7\u6a21\u677f\u7f16\u7801\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)onlyKey)) {
            throw new BusinessException("\u65e5\u5fd7\u552f\u4e00\u6807\u8bb0\u4e3a\u7a7a\uff01");
        }
        if (oldObject instanceof Collection || newObject instanceof Collection) {
            throw new BusinessException("\u6682\u4e0d\u652f\u6301\u96c6\u5408\u65e5\u5fd7\u5bf9\u6bd4\uff01");
        }
        CrmLogDto crmLogDto = new CrmLogDto(templateCode, LogEunm.OperationTypeEunm.UPDATE.getCode(), onlyKey, modularCode, oldObject, newObject, operationUserId, operationUserName);
        crmLogDto.setOperationTime(DateUtil.format((Date)DateUtil.getDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        RocketMQMessageBody msg = new RocketMQMessageBody();
        msg.setTag("CRMLOG");
        msg.setMsgBody(JSON.toJSONString((Object)crmLogDto));
        this.rocketMQProducer.convertAndSend(msg);
    }

    public void sendForDel(String modularCode, Map<String, Object> map, String operationUserId, String operationUserName) {
        if (CollectionUtils.isEmpty(map)) {
            return;
        }
        if (StringUtils.isEmpty((Object)modularCode)) {
            throw new BusinessException("\u6a21\u5757\u7f16\u7801\u4e3a\u7a7a\uff01");
        }
        CrmLogDto crmLogDto = new CrmLogDto(LogEunm.OperationTypeEunm.DEL.getCode(), "", map.keySet().iterator().next(), modularCode, map.values().iterator().next(), (Object)"", operationUserId, operationUserName);
        crmLogDto.setOperationTime(DateUtil.format((Date)DateUtil.getDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        RocketMQMessageBody msg = new RocketMQMessageBody();
        msg.setTag("CRMLOG");
        msg.setMsgBody(JSON.toJSONString((Object)crmLogDto));
        this.rocketMQProducer.convertAndSend(msg);
    }

    public void sendForDelBatch(String modularCode, List<Map<String, Object>> list, String operationUserId, String operationUserName) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        if (StringUtils.isEmpty((Object)modularCode)) {
            throw new BusinessException("\u6a21\u5757\u7f16\u7801\u4e3a\u7a7a\uff01");
        }
        CrmLogDto crmLogDto = new CrmLogDto(LogEunm.OperationTypeEunm.DEL.getCode(), "", "", modularCode, list, (Object)"", operationUserId, operationUserName);
        crmLogDto.setOperationTime(DateUtil.format((Date)DateUtil.getDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        RocketMQMessageBody msg = new RocketMQMessageBody();
        msg.setTag("CRMLOG");
        msg.setMsgBody(JSON.toJSONString((Object)crmLogDto));
        this.rocketMQProducer.convertAndSend(msg);
    }

    public void sendForAdd(String modularCode, Map<String, Object> map, String operationUserId, String operationUserName) {
        if (CollectionUtils.isEmpty(map)) {
            return;
        }
        if (StringUtils.isEmpty((Object)modularCode)) {
            throw new BusinessException("\u6a21\u5757\u7f16\u7801\u4e3a\u7a7a\uff01");
        }
        CrmLogDto crmLogDto = new CrmLogDto(LogEunm.OperationTypeEunm.ADD.getCode(), "", map.keySet().iterator().next(), modularCode, (Object)"", map.values().iterator().next(), operationUserId, operationUserName);
        crmLogDto.setOperationTime(DateUtil.format((Date)DateUtil.getDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        RocketMQMessageBody msg = new RocketMQMessageBody();
        msg.setTag("CRMLOG");
        msg.setMsgBody(JSON.toJSONString((Object)crmLogDto));
        this.rocketMQProducer.convertAndSend(msg);
    }

    public void sendForAddBatch(String modularCode, List<Map<String, Object>> list, String operationUserId, String operationUserName) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        if (StringUtils.isEmpty((Object)modularCode)) {
            throw new BusinessException("\u6a21\u5757\u7f16\u7801\u4e3a\u7a7a\uff01");
        }
        for (Map<String, Object> map : list) {
            this.sendForAdd(modularCode, map, operationUserId, operationUserName);
        }
        CrmLogDto crmLogDto = new CrmLogDto(LogEunm.OperationTypeEunm.ADD.getCode(), "", "", modularCode, (Object)"", list, operationUserId, operationUserName);
        crmLogDto.setOperationTime(DateUtil.format((Date)DateUtil.getDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        RocketMQMessageBody msg = new RocketMQMessageBody();
        msg.setTag("CRMLOG");
        msg.setMsgBody(JSON.toJSONString((Object)crmLogDto));
        this.rocketMQProducer.convertAndSend(msg);
    }
}

