/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.log.template.service.impl;

import com.alibaba.fastjson.JSON;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.log.template.entity.LogFieldEntity;
import com.biz.crm.log.template.entity.LogTemplateEntity;
import com.biz.crm.log.template.repositories.LogTemplateRepositories;
import com.biz.crm.log.template.service.LogTemplateService;
import com.biz.crm.log.template.util.LogTemplateUtil;
import com.biz.crm.nebular.log.template.LogFieldVo;
import com.biz.crm.nebular.log.template.LogTemplateVo;
import com.biz.crm.util.EsUtil;
import com.biz.crm.util.RedissonUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.redisson.api.RedissonClient;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.aggregation.AggregatedPage;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@ConditionalOnMissingBean(name={"logTemplateServiceImpl"})
@Service(value="logTemplateService")
public class LogTemplateServiceImpl
implements LogTemplateService {
    @Resource
    private RedissonClient redissonClient;
    @Resource
    private ElasticsearchTemplate elasticsearchTemplate;
    @Resource
    private RedissonUtil redissonUtil;
    @Resource
    private LogTemplateRepositories logTemplateRepositories;

    @Override
    public void add(LogTemplateVo vo) {
        ValidateUtils.validate((Object)vo.getBusinessName(), (String)"\u4e1a\u52a1\u6a21\u5757\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)vo.getMenuCode(), (String)"\u4e1a\u52a1\u6a21\u5757\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)vo.getTypeClassPath(), (String)"\u6a21\u677f\u7c7b\u5168\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)vo.getFieldList(), (String)"\u5b57\u6bb5\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        LogTemplateEntity logTemplateEntity = LogTemplateUtil.voToEntityForAdd(vo);
        this.logTemplateRepositories.save(logTemplateEntity);
    }

    @Override
    public PageResult<LogTemplateVo> listWithPage(LogTemplateVo vo) {
        PageResult pageResult = new PageResult();
        pageResult.setCount(Long.valueOf(Long.parseLong("0")));
        pageResult.setData(new ArrayList());
        if (!EsUtil.indexExsit((ElasticsearchTemplate)this.elasticsearchTemplate, LogTemplateEntity.class, (RedissonUtil)this.redissonUtil)) {
            return pageResult;
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (!StringUtils.isEmpty((String)vo.getMenuCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"menuCode.keyword", (String)vo.getMenuCode()));
        }
        if (null != vo.getEnableFlag()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"enableFlag", (Object)vo.getEnableFlag()));
        }
        if (!StringUtils.isEmpty((String)vo.getBusinessName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"businessName", (Object)vo.getBusinessName()));
        }
        String[] fileds = new String[]{"id", "menuCode", "businessName", "typeClassPath", "enableFlag"};
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"es_log_template_index"}).withQuery((QueryBuilder)boolQueryBuilder).withPageable((Pageable)PageRequest.of((int)(vo.getPageNum() - 1), (int)vo.getPageSize())).withFields(fileds).build();
        AggregatedPage scroll = this.elasticsearchTemplate.queryForPage((SearchQuery)searchQuery, LogTemplateVo.class);
        List list = scroll.getContent();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return pageResult;
        }
        pageResult.setData(list);
        pageResult.setCount(Long.valueOf(scroll.getTotalElements()));
        return pageResult;
    }

    @Override
    public LogTemplateVo findById(String id) {
        LogTemplateVo reVo = new LogTemplateVo();
        Optional optional = this.logTemplateRepositories.findById(id);
        if (null == optional || null == optional.get()) {
            throw new BusinessException("\u60a8\u6307\u5b9a\u7684\u6a21\u677f\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u88ab\u5220\u9664!");
        }
        LogTemplateEntity LogTemplateEntity2 = (LogTemplateEntity)optional.get();
        BeanUtils.copyProperties((Object)LogTemplateEntity2, (Object)reVo);
        Map<String, LogFieldEntity> fieldMap = LogTemplateEntity2.getFieldMap();
        reVo.setFieldList(new ArrayList());
        if (!CollectionUtils.isEmpty(fieldMap)) {
            ArrayList<LogFieldEntity> fieldEntityList = new ArrayList<LogFieldEntity>(fieldMap.values());
            reVo.setFieldList(JSON.parseArray((String)JSON.toJSONString(fieldEntityList), LogFieldVo.class));
        }
        return reVo;
    }

    @Override
    public void update(LogTemplateVo vo) {
        ValidateUtils.validate((Object)vo.getId(), (String)"\u8bf7\u6307\u5b9a\u8981\u7f16\u8f91\u7684\u6a21\u677f!");
        ValidateUtils.validate((Object)vo.getBusinessName(), (String)"\u4e1a\u52a1\u6a21\u5757\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)vo.getMenuCode(), (String)"\u4e1a\u52a1\u6a21\u5757\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)vo.getTypeClassPath(), (String)"\u6a21\u677f\u7c7b\u5168\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)vo.getFieldList(), (String)"\u5b57\u6bb5\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        Optional optional = this.logTemplateRepositories.findById(vo.getId());
        if (null == optional || null == optional.get()) {
            throw new BusinessException("\u6307\u5b9a\u7684\u6a21\u677f\u4e0d\u5b58\u5728\u8d27\u5df2\u7ecf\u88ab\u5220\u9664\uff01");
        }
        LogTemplateEntity logTemplateEntity = LogTemplateUtil.voToEntityForUpdate(vo, (LogTemplateEntity)optional.get());
        this.logTemplateRepositories.deleteById(vo.getId());
        this.logTemplateRepositories.save(logTemplateEntity);
    }

    @Override
    public void updateEnable(String id, YesNoEnum.YesNoCodeNumberEnum yesNoCodeNumberEnum) {
        Optional optional = this.logTemplateRepositories.findById(id);
        if (null == optional || null == optional.get()) {
            throw new BusinessException("\u60a8\u6307\u5b9a\u7684\u6a21\u677f\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u88ab\u5220\u9664!");
        }
        LogTemplateEntity LogTemplateEntity2 = (LogTemplateEntity)optional.get();
        LogTemplateEntity2.setEnableFlag(yesNoCodeNumberEnum.getCode());
        this.logTemplateRepositories.deleteById(LogTemplateEntity2.getId());
        this.logTemplateRepositories.save(LogTemplateEntity2);
    }

    @Override
    public void delByIds(ArrayList<String> ids) {
        this.logTemplateRepositories.deleteByIdIn(ids);
    }

    @Override
    public List<LogFieldVo> findFieldsByType(String type) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(type);
        }
        catch (ClassNotFoundException e) {
            throw new BusinessException("\u60a8\u6307\u5b9a\u7684\u7c7b\u4e0d\u5b58\u5728", (Throwable)e);
        }
        return LogTemplateUtil.packageFiledVo(LogTemplateUtil.getFields(clazz));
    }

    @Override
    public LogTemplateEntity findTemplateByCode(String code) {
        return this.logTemplateRepositories.findByMenuCode(code);
    }
}

