/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.log.template.util;

import com.alibaba.excel.util.CollectionUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.log.LogEunm;
import com.biz.crm.log.template.entity.LogFieldEntity;
import com.biz.crm.log.template.entity.LogTemplateEntity;
import com.biz.crm.nebular.log.template.LogFieldVo;
import com.biz.crm.nebular.log.template.LogTemplateVo;
import com.biz.crm.util.UUIDGenerator;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;

public class LogTemplateUtil {
    public static LogTemplateEntity voToEntityForAdd(LogTemplateVo vo) {
        LogTemplateEntity entity = new LogTemplateEntity();
        BeanUtils.copyProperties((Object)vo, (Object)entity);
        entity.setId(UUIDGenerator.generate());
        entity.setEnableFlag(YesNoEnum.YesNoCodeNumberEnum.YES.getCode());
        entity.setFieldMap(LogTemplateUtil.voToEntityForField(vo.getFieldList(), true));
        return entity;
    }

    public static LogTemplateEntity voToEntityForUpdate(LogTemplateVo vo, LogTemplateEntity logTemplateEntity) {
        LogTemplateEntity entity = new LogTemplateEntity();
        BeanUtils.copyProperties((Object)vo, (Object)entity);
        entity.setId(logTemplateEntity.getId());
        entity.setEnableFlag(logTemplateEntity.getEnableFlag());
        entity.setMenuCode(logTemplateEntity.getMenuCode());
        entity.setFieldMap(LogTemplateUtil.voToEntityForField(vo.getFieldList(), true));
        return entity;
    }

    public static Map<String, LogFieldEntity> voToEntityForField(List<LogFieldVo> filedVods, boolean subFlag) {
        if (CollectionUtils.isEmpty(filedVods)) {
            return new HashMap<String, LogFieldEntity>();
        }
        HashMap<String, LogFieldEntity> reMap = new HashMap<String, LogFieldEntity>();
        for (LogFieldVo fieldVo : filedVods) {
            LogFieldEntity fieldEntity = new LogFieldEntity();
            BeanUtils.copyProperties((Object)fieldVo, (Object)fieldEntity);
            if (subFlag) {
                Map<String, LogFieldEntity> subMap = LogTemplateUtil.voToEntityForField(fieldVo.getChildrenList(), false);
                fieldEntity.setJsonTemplate(JSONObject.parseObject((String)JSON.toJSONString(subMap)));
            }
            reMap.put(fieldVo.getFieldName(), fieldEntity);
        }
        return reMap;
    }

    public static Integer judgeClass(Class claszz) {
        if (claszz == Integer.class || claszz == Double.class || claszz == Long.class || claszz == Float.class || claszz == Character.class || claszz == Byte.class || claszz == String.class || claszz == BigDecimal.class) {
            return LogEunm.HostTypeEunm.BASIC.getCode();
        }
        if (claszz.isAssignableFrom(Collection.class)) {
            return LogEunm.HostTypeEunm.ONE2MANY.getCode();
        }
        return LogEunm.HostTypeEunm.ONE2ONE.getCode();
    }

    public static List<LogFieldVo> packageFiledVo(List<Field> fields) {
        if (CollectionUtils.isEmpty(fields)) {
            return new ArrayList<LogFieldVo>();
        }
        ArrayList<LogFieldVo> reList = new ArrayList<LogFieldVo>(fields.size());
        for (Field field : fields) {
            LogFieldVo vo = new LogFieldVo();
            vo.setFieldName(field.getName());
            vo.setDesc("");
            vo.setCompareFalg(YesNoEnum.YesNoCodeNumberEnum.YES.getCode());
            vo.setType(field.getType().getName());
            if (field.getType().isPrimitive()) {
                vo.setHostType(LogEunm.HostTypeEunm.BASIC.getCode());
            } else {
                vo.setHostType(LogTemplateUtil.judgeClass(field.getType()));
            }
            reList.add(vo);
        }
        return reList;
    }

    public static List<Field> getFields(Class clazz) {
        ArrayList fields = Lists.newArrayList();
        while (clazz != null && clazz != Object.class) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        return fields;
    }
}

