package com.biz.crm.crmlog.handle;

import com.biz.crm.crmlog.template.entity.LogFieldEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/12/16 11:34
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Grade {

    /**
     * 编码
     */
    private String code;

    /**
     * 名称
     */
    private String name;

    /**
     * 等级
     */
    private Integer level;

    /**
     * 创建模板
     * @return
     */
    public static Map<String, LogFieldEntity> createTemplate(){
        Map<String, LogFieldEntity> reMap = new HashMap<>();

        LogFieldEntity logFieldEntity1 = new LogFieldEntity();
        logFieldEntity1.setFieldName("code");
        logFieldEntity1.setDesc("编码");
        logFieldEntity1.setCompareFalg(1);
        logFieldEntity1.setType("java.lang.String");
        logFieldEntity1.setHostType(0);
        reMap.put("code",logFieldEntity1);

        LogFieldEntity logFieldEntity2 = new LogFieldEntity();
        logFieldEntity2.setFieldName("name");
        logFieldEntity2.setDesc("名称");
        logFieldEntity2.setCompareFalg(1);
        logFieldEntity2.setType("java.lang.String");
        logFieldEntity2.setHostType(0);
        reMap.put("name",logFieldEntity2);

        LogFieldEntity logFieldEntity3 = new LogFieldEntity();
        logFieldEntity3.setFieldName("level");
        logFieldEntity3.setDesc("等级");
        logFieldEntity3.setCompareFalg(1);
        logFieldEntity3.setType("java.lang.Integer");
        logFieldEntity3.setHostType(0);
        reMap.put("level",logFieldEntity3);
        return reMap;
    }

    public Grade(String code, String name, Integer level) {
        this.code = code;
        this.name = name;
        this.level = level;
    }

    /**
     * 创建一年级
     * @return
     */
    public static Grade createOneOld(){
        return new Grade("one","一年级",1);
    }

    /**
     * 创建一年级
     * @return
     */
    public static Grade createOneNew(){
        return new Grade("one","一年级(新)",1);
    }

    /**
     * 创建一年级
     * @return
     */
    public static Grade createTwoOld(){
        return new Grade("two","二年级",2);
    }

    /**
     * 创建一年级
     * @return
     */
    public static Grade createTwoNew(){
        return new Grade("two","二年级(新)",2);
    }

    /**
     * 创建所有的年级
     * @return
     */
    public static List<Grade> createAllOld(){
        List<Grade> list = new ArrayList<>();
        list.add(createOneOld());
        list.add(createTwoOld());
        return list;
    }

    /**
     * 创建所有的年级
     * @return
     */
    public static List<Grade> createAllNew(){
        List<Grade> list = new ArrayList<>();
        list.add(createOneNew());
        list.add(createTwoNew());
        return list;
    }
}
