package com.biz.crm.crmlog.handle.tool;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.crmlog.template.entity.LogFieldEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Description: 一对多字段对比（暂时只支持conllction子类）
 * @Author: zhangyuzhu
 * @Date: 2020/12/15 14:43
 **/
public class One2ManyConpare {

    /**
     * 比对自定义类型
     * @param logFieldEntity 模板
     * @param oldJsonObjects 改变之前的json
     * @param newJsonObjects 改变之后的json
     */
    public static Object compare(LogFieldEntity logFieldEntity, List<JSONObject> oldJsonObjects, List<JSONObject> newJsonObjects){
        if(logFieldEntity == null || logFieldEntity.getChildren() == null){
            return null;
        }
        List<JSONObject> reList = new ArrayList<>();
        String onlyKey = logFieldEntity.getOnlyKey();
        JSONObject reObj = new JSONObject();
        if(StringUtils.isEmpty(onlyKey)){
            StringBuilder stb = new StringBuilder(logFieldEntity.getDesc()).append("未设置唯一key");
            reObj.put("解析失败",stb.toString());
        }
        oldJsonObjects = CollectionUtils.isEmpty(oldJsonObjects)?new ArrayList<>():oldJsonObjects;
        newJsonObjects = CollectionUtils.isEmpty(newJsonObjects)?new ArrayList<>():newJsonObjects;
        //更新的对象
        List<Map<String,JSONObject>> updateList = new ArrayList<>();
        //map
        Map<String,JSONObject> oldJsonObjectMap = transforToMapByOnlyKey(oldJsonObjects,onlyKey);
        Map<String,JSONObject> newJsonObjectMap = transforToMapByOnlyKey(newJsonObjects,onlyKey);

        //先比对删除的{如果更新之前没有，则就没有删除的}
        if(!CollectionUtils.isEmpty(oldJsonObjects)){
            for (Map.Entry<String,JSONObject> entry : oldJsonObjectMap.entrySet()) {
                JSONObject newObj = newJsonObjectMap.get(entry.getKey());
                if(null == newObj){
                    StringBuilder stb = new StringBuilder("删除了：");
                    stb.append(entry.getKey());
                    JSONObject json = new JSONObject();
                    json.put(stb.toString(),"");
                    reList.add(json);
                }else {
                    Map<String,JSONObject> map = new HashMap<>();
                    map.put("old",entry.getValue());
                    map.put("new",newObj);
                    updateList.add(map);
                }
            }
        }

        //比对新创建的{如果更新之后没有，则就没有新创建的}
        if(!CollectionUtils.isEmpty(newJsonObjects)){
            for (Map.Entry<String,JSONObject> entry : newJsonObjectMap.entrySet()) {
                JSONObject oldObj = oldJsonObjectMap.get(entry.getKey());
                if(null == oldObj){
                    StringBuilder stb = new StringBuilder("新创建了:");
                    stb.append(entry.getKey());
                    JSONObject json = new JSONObject();
                    json.put(stb.toString(),"");
                    reList.add(json);
                }else {
                    Map<String,JSONObject> map = new HashMap<>();
                    map.put("old",oldObj);
                    map.put("new",entry.getValue());
                    updateList.add(map);
                }
            }
        }

        //循环模板对比更新的数据
        if(CollectionUtils.isEmpty(updateList)){
            return reList;
        }
        for(Map<String,JSONObject> map : updateList){
            JSONObject result = One2OneCompare.compare(logFieldEntity.getChildren(),
                    map.get("old"),
                    map.get("new")
            );
            if(!result.isEmpty()){
                reList.add(result);
            }
        }
        return reList;
    }

    /**
     * 组装唯一key
     * @return
     */
    public static String packageOnlykey(JSONObject value,String onlyKeyValue){
        String[] keys = onlyKeyValue.split(",");
        StringBuilder onlyKey = new StringBuilder();
        for(String str : keys){
            Object obj = value.get(str);
            if(!StringUtils.isEmpty(obj)){
                onlyKey.append("【").append(obj).append("】");
            }
        }
        return onlyKey.toString();
    }

    /**
     * 将list转换成map，key为唯一值
     * @return
     */
    public static Map transforToMapByOnlyKey(List<JSONObject> jsonObjects,String onlyKeyValue){
        if(CollectionUtils.isEmpty(jsonObjects)){
            return new HashMap();
        }
        Map reMap = new HashMap(jsonObjects.size());
        for(JSONObject object : jsonObjects){
            reMap.put(packageOnlykey(object,onlyKeyValue),object);
        }
        return reMap;
    }
}
