package com.biz.crm.button.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 按钮表实体类
 *
 * @author zxw
 * @date 2020-11-18 11:33:08
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_button")
public class MdmButtonEntity extends CrmExtTenEntity<MdmButtonEntity> {


    /**
     * 按钮编码
     */
    private String buttonCode;

    /**
     * 按钮名称
     */
    private String buttonName;


    @ApiModelProperty("按钮类型:0表头按钮，1行按钮")
    private String buttonType;

    @ApiModelProperty("图标编码")
    private String iconCode;
}
