package com.biz.crm.approval.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 审批配置条件字段表实体类
 *
 * @author Tao.Chen
 * @date 2021-03-01 17:50:29
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_approval_config_condition")
@CrmTable(name = "mdm_approval_config_condition", tableNote = "审批配置业务数据字段表实体类")
public class MdmApprovalConfigConditionEntity extends CrmBaseEntity<MdmApprovalConfigConditionEntity> {

    @CrmColumn(name = "menu_code", length = 64, note = "菜单编码")
    @Deprecated
    private String menuCode;

    @CrmColumn(name = "business_code", length = 64, nullable = false, note = "业务编码")
    private String businessCode;

    @CrmColumn(name = "control_flag", length = 4, nullable = false, note = "条件生效状态")
    private String controlFlag;

    @CrmColumn(name = "field_code", length = 64, nullable = false, note = "字段编码")
    private String fieldCode;

    @CrmColumn(name = "field_name", length = 64, nullable = false, note = "字段名称")
    private String fieldName;

    @CrmColumn(name = "field_type", length = 32, nullable = false, note = "字段类型")
    private String fieldType;

    @CrmColumn(name = "field_data_source", length = 128, note = "字段值来源")
    private String fieldDataSource;

    @CrmColumn(name = "field_keywords", length = 255, nullable = false, note = "关键值，多个用逗号间隔")
    private String fieldKeywords;

    @CrmColumn(name = "compare_type", length = 32, nullable = false, note = "字段比较类型")
    private String compareType;

}
