package com.biz.crm.approval.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 审批配置主表实体类
 *
 * @author Tao.Chen
 * @date 2021-03-01 17:50:29
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_approval_config")
@CrmTable(name = "mdm_approval_config", tableNote = "审批配置表", indexes = {
        @Index(name = "uk_f_approval_business_code", unique = true, columnList = "business_code")
})
public class MdmApprovalConfigEntity extends CrmBaseEntity<MdmApprovalConfigEntity> {

    @CrmColumn(name = "menu_code", length = 64, note = "菜单编码")
    private String menuCode;

    @CrmColumn(name = "business_code", length = 128, nullable = false, unique = true, note = "业务编码")
    private String businessCode;

    @CrmColumn(name = "business_name", length = 128, nullable = false, note = "业务名称")
    private String businessName;

    @CrmColumn(name = "control_flag", length = 4, nullable = false, note = "审批开关")
    private String controlFlag;

    @CrmColumn(name = "approval_type", length = 32, note = "审批类型")
    private String approvalType;

    @CrmColumn(name = "default_work_flow_key", length = 128, note = "自动发起流程审批的流程key")
    private String defaultWorkFlowKey;

    @CrmColumn(name = "control_scope", length = 32, note = "控制范围")
    private String controlScope;

    @CrmColumn(name = "group_check_way", length = 32, note = "条件判断逻辑")
    private String groupCheckWay;

}
