package com.biz.crm.approval.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 审批配置提交人信息表实体类
 *
 * @author Tao.Chen
 * @date 2021-03-01 17:50:29
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_approval_config_submitter")
@CrmTable(name = "mdm_approval_config_submitter", tableNote = "审批配置提交人信息表实体类")
public class MdmApprovalConfigSubmitterEntity extends CrmBaseEntity<MdmApprovalConfigSubmitterEntity> {

    @CrmColumn(name = "business_code", length = 64, nullable = false, note = "业务编码")
    private String businessCode;

    @CrmColumn(name = "control_flag", length = 4, nullable = false, note = "条件生效状态")
    private String controlFlag;

    @CrmColumn(name = "submitter_type", length = 32, nullable = false, note = "匹配对象")
    private String submitterType;

    @CrmColumn(name = "field_keywords", length = 255, note = "关键值，多个用逗号隔开")
    private String fieldKeywords;

    @CrmColumn(name = "compare_type", length = 32, note = "比较类型")
    private String compareType;

}
