package com.biz.crm.availablelistrule.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * @Description: 可够清单规则购买范围
 * @Author: zhangyuzhu
 * @Date: 2020/9/24 16:59
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("mdm_available_list_rule_area")
@CrmTable(name = "mdm_available_list_rule_area",tableNote = "可够清单规则购买范围",indexes = {
        @Index(name ="available_area_index1",columnList = "rule_code"),
        @Index(name ="available_area_index2",columnList = "cus_code")
})
public class AvailableListRuleAreaEntity extends CrmExtEntity<AvailableListRuleAreaEntity> {


    /**
     * 规则编码
     */
	@CrmColumn(name = "rule_code", length = 64)
    private String ruleCode;

    /**
     * 组织编码(包含客户和终端)(仅仅是保存前段显示用,瞬时数据)
     */
	@CrmColumn(name = "org_code", length = 64)
    private String orgCode;

    /**
     * 组织名称(包含客户和终端)(仅仅是保存前段显示用,瞬时数据)
     */
	@CrmColumn(name = "org_name", length = 64)
    private String orgName;

    /**
     * 客户编码
     */
	@CrmColumn(name = "cus_code", length = 64)
    private String cusCode;

    /**
     * 客户名称
     */
	@CrmColumn(name = "cus_name", length = 64)
    private String cusName;

    /**
     * 客户所属组织编码
     */
	@CrmColumn(name = "cus_org_code", length = 64)
    private String cusOrgCode;

    /**
     * 客户所属组织名称
     */
	@CrmColumn(name = "cus_org_name", length = 64)
    private String cusOrgName;

    /**
     * 客户所属渠道编码
     */
	@CrmColumn(name = "cus_channel_code", length = 64)
    private String cusChannelCode;

    /**
     * 客户所属渠道名称
     */
	@CrmColumn(name = "cus_channel_name", length = 64)
    private String cusChannelName;


    /**
     * 终端编码
     */
	@CrmColumn(name = "terminal_code", length = 64)
    private String terminalCode;

    /**
     * 终端名称
     */
	@CrmColumn(name = "terminal_name", length = 128)
    private String terminalName;

    /**
     * 终端所属组织编码
     */
	@CrmColumn(name = "terminal_org_code", length = 64)
    private String terminalOrgCode;

    /**
     * 终端所属组织名称
     */
	@CrmColumn(name = "terminal_org_name", length = 64)
    private String terminalOrgName;

    /**
     * 终端所属渠道编码
     */
	@CrmColumn(name = "terminal_channel_code", length = 64)
    private String terminalChannelCode;

    /**
     * 终端所属渠道名称
     */
	@CrmColumn(name = "terminal_channel_name", length = 64)
    private String terminalChannelName;
}
