package com.biz.crm.availablelistrule.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * @Description: 可够清单规则表主表
 * @Author: zhangyuzhu
 * @Date: 2020/9/24 16:59
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("mdm_available_list_rule")
@CrmTable(name = "mdm_available_list_rule",tableNote = "可够清单规则表主表",indexes = {
        @Index(name = "available_list_index1",columnList = "rule_code",unique = true)
})
public class AvailableListRuleEntity extends CrmExtEntity<AvailableListRuleEntity> {

    /**
     * 编码
     */
	@CrmColumn(name = "code", length = 64)
    private String code;


    /**
     * 名称
     */
	@CrmColumn(name = "name", length = 64)
    private String name;

    /**
     * 规则编码(系统自动生成)
     */
	@CrmColumn(name = "rule_code", length = 64)
    private String ruleCode;

    /**
     * 类型
     */
	@CrmColumn(name = "type", length = 64)
    private Integer type;


    /**
     * 维度
     */
	@CrmColumn(name = "dimension", length = 64)
    private Integer dimension;


    /**
     * 规则来源编码
     */
    @CrmColumn(name = "source",length = 8)
    private String source;

    /**
     * 规则来源记录id
     */
    @CrmColumn(name = "source_id",length = 38)
    private String sourceId;
}
