package com.biz.crm.availablelistrule.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * @Description: 可够清单规则商品范围
 * @Author: zhangyuzhu
 * @Date: 2020/9/24 16:59
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("mdm_available_list_rule_goods")
@CrmTable(name = "mdm_available_list_rule_goods",tableNote ="可够清单规则商品范围" ,indexes = {
        @Index(name ="available_goods_index1",columnList = "rule_code"),
        @Index(name ="available_goods_index2",columnList = "goods_code")
})
public class AvailableListRuleGoodsEntity extends CrmExtEntity<AvailableListRuleGoodsEntity> {


    /**
     * 规则编码
     */
	@CrmColumn(name = "rule_code", length = 64)
    private String ruleCode;

    /**
     * 商品编码
     */
	@CrmColumn(name = "goods_code", length = 64)
    private String goodsCode;

    /**
     * 商品名称
     */
	@CrmColumn(name = "goods_name", length = 64)
    private String goodsName;

    /**
     * 商品规格
     */
	@CrmColumn(name = "product_spec", length = 64)
    private String productSpec;

    /**
     * 产品层级code
     */
	@CrmColumn(name = "product_level_code", length = 64)
    private String productLevelCode;

    /**
     * 产品层级名称
     */
	@CrmColumn(name = "product_level_name", length = 64)
    private String productLevelName;

    /**
     * 是否是产品层级(数据字典)
     */
	@CrmColumn(name = "product_level_flag", length = 64)
    private String productLevelFlag;


}
