package com.biz.crm.button.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 按钮-角色关联实体类
 *
 * @author zxw
 * @date 2020-11-18 11:51:48
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_button_role")
@CrmTable(name = "mdm_button_role",tableNote = "按钮-角色关联实体类")
public class MdmButtonRoleEntity extends BaseIdEntity {

    /**
     * 菜单编码
     */
	@CrmColumn(name = "parent_code", length = 64)
    private String parentCode;

    /**
     * 功能编码
     */
	@CrmColumn(name = "function_code", length = 64)
    private String functionCode;

    /**
     * 按钮编码
     */
	@CrmColumn(name = "button_code", length = 64)
    private String buttonCode;

    /**
     * 角色编码
     */
	@CrmColumn(name = "role_code", length = 64)
    private String roleCode;

}
