package com.biz.crm.coderule.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 编码规则实体类
 *
 * @author Tao.Chen
 * @date 2020-11-05 10:47:13
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_code_rule")
@CrmTable(name = "mdm_code_rule",tableNote = "编码规则实体类")
public class MdmCodeRuleEntity extends BaseIdEntity {

    /**
     * 业务key
     */
	@CrmColumn(name = "rule_code", length = 64)
    private String ruleCode;

    /**
     * 前缀
     */
	@CrmColumn(name = "prefix", length = 64)
    private String prefix;

    /**
     * 时间戳格式
     */
	@CrmColumn(name = "date_format", length = 64)
    private String dateFormat;

    /**
     * 编码总长度
     */
	@CrmColumn(name = "code_length", length = 64)
    private Integer codeLength;

    /**
     * 规则描述
     */
	@CrmColumn(name = "rule_description", length = 64)
    private String ruleDescription;

    /**
     * 起始值
     */
	@CrmColumn(name = "initial_value", length = 64)
    private Integer initialValue;

    /**
     * 当前值
     */
	@CrmColumn(name = "current_value", length = 64)
    private Integer currentValue;

    /**
     * 生成时间
     */
	@CrmColumn(name = "generate_date", length = 64)
    private String generateDate;

    /**
     * 创建日期
     */
	@CrmColumn(name = "create_date", length = 64)
    private String createDate;

    /**
     * 创建时间
     */
	@CrmColumn(name = "create_date_second", length = 64)
    private String createDateSecond;

    /**
     * 创建人姓名
     */
	@CrmColumn(name = "create_name", length = 64)
    private String createName;

    /**
     * 更新日期
     */
	@CrmColumn(name = "update_date", length = 64)
    private String updateDate;

    /**
     * 更新时间
     */
	@CrmColumn(name = "update_date_second", length = 64)
    private String updateDateSecond;

    /**
     * 更新人姓名
     */
	@CrmColumn(name = "update_name", length = 64)
    private String updateName;

    /**
     * 所属模块
     */
	@CrmColumn(name = "rule_module", length = 64)
    private String ruleModule;

}
