package com.biz.crm.cusorg.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmTreeEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * @Description: mdm中客户组织实体类
 * @Author: zhangyuzhu
 * @Date: 2020/8/14 10:58
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("mdm_cus_org")
@CrmTable(name = "mdm_cus_org",tableNote = "mdm中客户组织实体类",indexes = {
        @Index(name = "mdm_cus_org_index1",columnList ="customer_org_code" )
})
public class MdmCusOrgEntity extends CrmTreeEntity<MdmCusOrgEntity> {

    /**
     * 客户组织编码
     */
	@CrmColumn(name = "customer_org_code", length = 64)
    private String customerOrgCode;

    /**
     * 客户组织名称
     */
	@CrmColumn(name = "customer_org_name", length = 128)
    private String customerOrgName;

    /**
     * 客户组织层级
     */
	@CrmColumn(name = "customer_org_level", length = 64)
    private String customerOrgLevel;

    /**
     * 客户组织类型
     */
	@CrmColumn(name = "customer_org_type", length = 64)
    private String customerOrgType;

    /**
     * 客户组织描述
     */
	@CrmColumn(name = "customer_org_desc", length = 128)
    private String customerOrgDesc;

    /**
     * 上级编码
     */
	@CrmColumn(name = "parent_code", length = 64)
    private String parentCode;

}
