package com.biz.crm.customer.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 客户信息：收货地址实体类
 *
 * @author zxw
 * @date 2020-09-10 12:09:54
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_customer_address")
@CrmTable(name = "mdm_customer_address",tableNote = "收货地址实体类",indexes = {
        @Index(name = "mdm_customer_address_index1",columnList ="customer_code" )
})
public class MdmCustomerAddressEntity extends CrmExtTenEntity<MdmCustomerAddressEntity> {


    /**
     * 市
     */
	@CrmColumn(name = "city_code", length = 32)
    private String cityCode;

    /**
     * 区
     */
	@CrmColumn(name = "district_code", length = 32)
    private String districtCode;

    /**
     * 省
     */
	@CrmColumn(name = "province_code", length = 32)
    private String provinceCode;

    /**
     * 送达方编码
     */
	@CrmColumn(name = "destination_code", length = 64)
    private String destinationCode;

    /**
     * 送达方名称
     */
	@CrmColumn(name = "destination_name", length = 128)
    private String destinationName;

    /**
     * 详细地址
     */
	@CrmColumn(name = "detailed_address", length = 255)
    private String detailedAddress;

    /**
     * 联系人
     */
	@CrmColumn(name = "contact_name", length = 128)
    private String contactName;

    /**
     * 联系电话
     */
	@CrmColumn(name = "contact_phone", length = 64)
    private String contactPhone;

    /**
     * 是否默认地址，1：是，0：否
     */
	@CrmColumn(name = "default_address", length = 16)
    private String defaultAddress;

    /**
     * 客户编码
     */
	@CrmColumn(name = "customer_code", length = 64)
    private String customerCode;

    @ApiModelProperty("有效开始时间")
	@CrmColumn(name = "start_time", length = 64)
    private String startTime;

    @ApiModelProperty("有效结束时间")
	@CrmColumn(name = "end_time", length = 64)
    private String endTime;

}
