package com.biz.crm.customer.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 客户开票信息实体类
 *
 * @author zxw
 * @date 2021-01-24 22:48:12
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_customer_bill")
@CrmTable(name = "mdm_customer_bill",tableNote ="客户开票信息实体类" )
public class MdmCustomerBillEntity extends CrmExtTenEntity<MdmCustomerBillEntity> {

    /**
     * 客户编码
     */
	@CrmColumn(name = "customer_code", length = 64)
    private String customerCode;

    /**
     * 开票单位
     */
	@CrmColumn(name = "bill_company", length = 64)
    private String billCompany;

    /**
     * 税号
     */
	@CrmColumn(name = "tax_number", length = 64)
    private String taxNumber;

    /**
     * 法人
     */
	@CrmColumn(name = "legal", length = 64)
    private String legal;

    /**
     * 开户银行
     */
	@CrmColumn(name = "deposit_bank", length = 128)
    private String depositBank;

    /**
     * 银行帐号
     */
	@CrmColumn(name = "bank_account", length = 64)
    private String bankAccount;

    /**
     * 是否是默认开票信息，1是0否
     */
	@CrmColumn(name = "bill_main", length = 64)
    private String billMain;

}
