package com.biz.crm.customer.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Index;

/**
 * 实体类
 *
 * @author zxw
 * @date 2020-09-02 14:10:26
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_customer_contact")
@CrmTable(name = "mdm_customer_contact",tableNote = "客户联系人信息",indexes = {
        @Index(name = "mdm_customer_contact_index1",columnList = "customer_code")
})
public class MdmCustomerContactEntity extends CrmExtTenEntity<MdmCustomerContactEntity> {

    /**
     * 客户id
     */
	@CrmColumn(name = "customer_code", length = 64)
    private String customerCode;

    /**
     * 联系人姓名
     */
	@CrmColumn(name = "contact_name", length = 128)
    private String contactName;

    /**
     * 联系人电话
     */
	@CrmColumn(name = "contact_phone", length = 64)
    private String contactPhone;

    @ApiModelProperty("主联系人,1是0否")
	@CrmColumn(name = "contact_main", length = 8)
    private String contactMain;

}
