package com.biz.crm.customer.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmTreeEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 实体类
 *
 * @author zxw
 * @date 2020-09-02 14:10:25
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_customer_docking")
@CrmTable(name = "mdm_customer_docking",tableNote = "实体类")
public class MdmCustomerDockingEntity extends CrmTreeEntity<MdmCustomerDockingEntity> {


    /**
     * 客户编码
     */
	@CrmColumn(name = "customer_code", length = 64)
    private String customerCode;

    /**
     * 职位编码
     */
	@CrmColumn(name = "position_code", length = 64)
    private String positionCode;

    /**
     * 组织编码
     */
	@CrmColumn(name = "org_code", length = 64)
    private String orgCode;

    /**
     * 联系方式
     */
	@CrmColumn(name = "contact", length = 128)
    private String contact;

    /**
     * 用户帐号
     */
	@CrmColumn(name = "user_account", length = 64)
    private String userAccount;

    /**
     * 渠道
     */
	@CrmColumn(name = "channel", length = 64)
    private String channel;

    /**
     * 二批商
     */
	@CrmColumn(name = "second_customer_code", length = 64)
    private String secondCustomerCode;

}
