package com.biz.crm.customer.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmTreeEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Index;

/**
 * 实体类
 *
 * @author zxw
 * @date 2020-09-02 14:10:25
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_customer")
@CrmTable(name = "mdm_customer",tableNote = "客户主数据",indexes = {
        @Index(name = "mdm_customer_index1",columnList = "customer_code",unique = true),
        @Index(name = "mdm_customer_index2",columnList = "org_code",unique = false)
})
public class MdmCustomerEntity extends CrmTreeEntity<MdmCustomerEntity> {

    /**
     * 高德地图ID
     */
    @ApiModelProperty("高德地图ID")
    @CrmColumn(name = "amap_id", length = 64)
    private String amapId;


    /**
     * 渠道
     */
    @CrmColumn(name = "channel", length = 64)
    private String channel;

    /**
     * 客户编码
     */
    @CrmColumn(name = "customer_code", length = 64)
    private String customerCode;

    /**
     * 客户组织编码
     */
    @CrmColumn(name = "customer_org_code", length = 64)
    private String customerOrgCode;

    /**
     * 客户名称
     */
    @CrmColumn(name = "customer_name", length = 128)
    private String customerName;

    /**
     * 客户类型
     */
    @CrmColumn(name = "customer_type", length = 64)
    private String customerType;

    /**
     * 操作类型
     */
    @CrmColumn(name = "operate_type", length = 64)
    private String operateType;

    /**
     * 企业组织编码
     */
    @CrmColumn(name = "org_code", length = 64)
    private String orgCode;


    /**
     * 市
     */
    @CrmColumn(name = "city_code", length = 32)
    private String cityCode;

    @CrmColumn(name = "city_name", length = 128)
    private String cityName;

    /**
     * 区
     */
    @CrmColumn(name = "district_code", length = 32)
    private String districtCode;

    @CrmColumn(name = "district_name", length = 128)
    private String districtName;

    /**
     * 省
     */
    @CrmColumn(name = "province_code", length = 32)
    private String provinceCode;

    @CrmColumn(name = "province_name", length = 128)
    private String provinceName;

    /**
     * 注册地址
     */
    @CrmColumn(name = "registered_address", length = 128)
    private String registeredAddress;

    /**
     * 工程名
     */
    @CrmColumn(name = "project_name", length = 128)
    private String projectName;

    /**
     * 客户联系方式
     */
    @CrmColumn(name = "customer_contact", length = 128)
    private String customerContact;

    /**
     * 客户法人代表
     */
    @CrmColumn(name = "legal_representative", length = 128)
    private String legalRepresentative;

    /**
     * 用户帐号
     */
    @CrmColumn(name = "user_name", length = 64)
    @Deprecated
    private String userName;

    /**
     * 是否是主客户：1是0否
     */
    @CrmColumn(name = "customer_primary", length = 8)
    @Deprecated
    private String customerPrimary;

    /**
     * 锁定状态：009正常，003冻结
     */
    @CrmColumn(name = "lock_state", length = 8)
    private String lockState;

    @ApiModelProperty("经度")
    @CrmColumn(name = "longitude", length = 64)
    private String longitude;
    @ApiModelProperty("纬度")
    @CrmColumn(name = "latitude", length = 64)
    private String latitude;
    @ApiModelProperty("erp编码")
    @CrmColumn(name = "erp_code", length = 64)
    private String erpCode;

    @ApiModelProperty("审批状态,枚举MdmBpmStatusEnum")
    @CrmColumn(name = "act_approve_status", length = 64)
    private String actApproveStatus;

    @ApiModelProperty("价格组")
    @CrmColumn(name = "price_group", length = 64)
    private String priceGroup;
    @ApiModelProperty("合作状态")
    @CrmColumn(name = "cooperate_status", length = 64)
    private String cooperateStatus;

    /**
     * 审批类型
     */
    @CrmColumn(name = "approval_type", length = 32)
    private String approvalType;

    /**
     * 流程编号
     */
    @CrmColumn(name = "process_code", length = 64)
    private String processCode;

    /**
     * 数据字典source_type
     */
    @CrmColumn(name = "source_type",length = 32,note = "数据来源")
    private String sourceType;

    /**
     * 业务来源系统
     */
    @CrmColumn(name = "from_type",length = 32,note = "业务来源系统")
    private String fromType;
}
