package com.biz.crm.customer.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Index;

/**
 * @author zxw
 * @date 2021-05-10 11:23
 **/
@TableName("mdm_customer_media")
@CrmTable(name = "mdm_customer_media",tableNote = "客户主数据",indexes = {
        @Index(name = "mdm_customer_media_index1",columnList = "customer_code",unique = false),
})
@EqualsAndHashCode(callSuper = true)
@Data
public class MdmCustomerMediaEntity extends BaseIdEntity {

    /**
     * 客户编码
     */
    @CrmColumn(name = "customer_code",length = 64)
    private String customerCode;

    /**
     * 图片类型
     */
    @CrmColumn(name="url_type",length = 12,mysqlType = "int",oracleType = "int")
    private Integer urlType;

    /**
     * 图片名称
     */
    @CrmColumn(name = "file_name",length = 128)
    private String fileName;

    /**
     * 图片地址
     */
    @CrmColumn(name = "url",length = 255)
    private String url;
}
