package com.biz.crm.customer.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;


/**
 * @className MdmCustomerProductEntity
 * @description 客户对接人商品信息实体表
 * @author Jaye
 * @date 2022/05/30
 **/
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_customer_product")
@CrmTable(name = "mdm_customer_product",tableNote = "客户对接人商品信息",indexes = {
        @Index(name = "mdm_customer_product_index",columnList = "customer_code")

})
public class MdmCustomerProductEntity extends CrmExtTenEntity<MdmCustomerProductEntity> {


    /**
     * 客户编码
     */
    @CrmColumn(name = "customer_code", length = 64)
    private String customerCode;

    /**
     * 商品编码
     */
	@CrmColumn(name = "product_code", length = 64)
    private String productCode;


    /**
     * 商品名称
     */
	@CrmColumn(name = "product_name", length = 300)
    private String productName;

    /**
     * 商品类型
     */
	@CrmColumn(name = "product_type", length = 64)
    private String productType;


}
