package com.biz.crm.customer.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 客户与组织关联表实体类
 *
 * @author zxw
 * @date 2020-12-21 09:50:12
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_customer_r_org")
@CrmTable(name = "mdm_customer_r_org",tableNote = "客户与组织关联表实体类",indexes = {
        @Index(name = "mdm_customer_r_org_index1",columnList = "customer_code"),
        @Index(name = "mdm_customer_r_org_index2",columnList = "org_code")
})
public class MdmCustomerROrgEntity extends CrmExtEntity<MdmCustomerROrgEntity> {


    /**
     * 客户编码
     */
	@CrmColumn(name = "customer_code", length = 64)
    private String customerCode;

    /**
     * 组织编码
     */
	@CrmColumn(name = "org_code", length = 64)
    private String orgCode;

}
