package com.biz.crm.customer.model;




import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmTreeTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 客户信息销售区域实体类
 *
 * @author zxw
 * @date 2020-11-16 15:50:20
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_customer_sale_area")
@CrmTable(name = "mdm_customer_sale_area",tableNote = "客户信息销售区域实体类",indexes = {
        @Index(name ="customer_sale_area_index1",columnList = "customer_code")
})
public class MdmCustomerSaleAreaEntity extends CrmTreeTenEntity<MdmCustomerSaleAreaEntity> {


    /**
     * 客户编码
     */
	@CrmColumn(name = "customer_code", length = 64)
    private String customerCode;

    /**
     * 一级区域
     */
	@CrmColumn(name = "area_one", length = 64)
    private String areaOne;

    /**
     * 二级区域
     */
	@CrmColumn(name = "area_two", length = 64)
    private String areaTwo;


    /**
     * 品牌
     */
    @CrmColumn(name = "brand", length = 64)
    private String brand;


    @ApiModelProperty("三级区域")
	@CrmColumn(name = "area_three", length = 64)
    private String areaThree;

}
