package com.biz.crm.customer.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 客户供货关系明细实体类
 *
 * @author zxw
 * @date 2020-12-16 14:28:18
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_customer_supply_detail")
@CrmTable(name = "mdm_customer_supply_detail",tableNote = "客户供货关系明细实体类",indexes = {
        @Index(name = "customer_supply_detail_index1",columnList = "code"),
        @Index(name = "customer_supply_detail_index2",columnList = "supply_id")
})
public class MdmCustomerSupplyDetailEntity extends CrmExtTenEntity<MdmCustomerSupplyDetailEntity> {

    /**
     * 类型1商品2产品层级
     */
	@CrmColumn(name = "data_type", length = 64)
    private String dataType;

    /**
     * 编码
     */
	@CrmColumn(name = "code", length = 64)
    private String code;

    /**
     * 描述
     */
	@CrmColumn(name = "name", length = 128)
    private String name;

    /**
     * 供货关系id
     */
	@CrmColumn(name = "supply_id", length = 64)
    private String supplyId;

}
