package com.biz.crm.customer.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 客户标签实体
 *
 * @author yangshan
 * @date 2021-3-4 11:44:19
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_customer_tag")
@ApiModel(value = "MdmCustomerTagEntity", description = "客户标签")
@CrmTable(name = "mdm_customer_tag",tableNote = "客户标签实体")
public class MdmCustomerTagEntity extends CrmExtTenEntity<MdmCustomerTagEntity> {

    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
	@CrmColumn(name = "client_code", length = 64)
    private String clientCode;

    /**
     * 标签类型
     */
    @ApiModelProperty("标签类型")
	@CrmColumn(name = "tag_type", length = 64)
    private String tagType;

    /**
     * 标签描述
     */
    @ApiModelProperty("标签描述")
	@CrmColumn(name = "tag_description", length = 64)
    private String tagDescription;
}
