package com.biz.crm.customer.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Index;

/**
 * 实体类
 *
 * @author zxw
 * @date 2020-09-02 14:10:25
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_customer_terminal")
@CrmTable(name = "mdm_customer_terminal",tableNote = "实体类",indexes = {
        @Index(name = "mdm_customer_terminal_index1",columnList ="customer_code" ),
        @Index(name = "mdm_customer_terminal_index2",columnList ="terminal_code" )
})
public class MdmCustomerTerminalEntity extends BaseIdEntity {


    /**
     * 客户
     */
	@CrmColumn(name = "customer_code", length = 64)
    private String customerCode;

    /**
     * 终端
     */
	@CrmColumn(name = "terminal_code", length = 64)
    private String terminalCode;

}
