package com.biz.crm.customermaterial.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 客户物料实体类
 *
 * @author huang.long
 * @date 2020-09-02 22:09:56
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_customer_material")
@CrmTable(name = "mdm_customer_material",tableNote = "客户物料实体类")
public class MdmCustomerMaterialEntity extends CrmExtEntity<MdmCustomerMaterialEntity> {

    /**
     * 客户组织编码
     */
	@CrmColumn(name = "customer_org_code", length = 64)
    private String customerOrgCode;

    /**
     * 物料编码
     */
	@CrmColumn(name = "material_code", length = 64)
    private String materialCode;

    /**
     * 条形码
     */
	@CrmColumn(name = "bar_code", length = 64)
    private String barCode;

}
