package com.biz.crm.dict.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 数据字典扩展字段配置表实体类
 *
 * @author Tao.Chen
 * @date 2020-11-20 15:00:54
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_dict_attr_conf")
@CrmTable(name = "mdm_dict_attr_conf",tableNote = "数据字典扩展字段配置表实体类")
public class MdmDictAttrConfEntity extends CrmBaseEntity<MdmDictAttrConfEntity> {

    /**
     * 数据字典类型编码
     */
	@CrmColumn(name = "dict_type_code", length = 64)
    private String dictTypeCode;

    /**
     * 字段编码
     */
	@CrmColumn(name = "field_code", length = 64)
    private String fieldCode;

    /**
     * 字段显示名称
     */
	@CrmColumn(name = "field_name", length = 128)
    private String fieldName;

    /**
     * 对应data表扩展字段
     */
	@CrmColumn(name = "ext_field", length = 64)
    private String extField;

    /**
     * 是否必填 0否 1是
     */
	@CrmColumn(name = "required", length = 64)
    private String required;

    /**
     * 显示顺序
     */
	@CrmColumn(name = "show_order", length = 64)
    private String showOrder;

    /**
     * 下拉框数据字典
     */
	@CrmColumn(name = "select_dict_type_code", length = 64)
    private String selectDictTypeCode;

    /**
     * 下拉框单选控制
     */
    @CrmColumn(name = "select_single_only", length = 4)
    private String selectSingleOnly;

}
