package com.biz.crm.dict.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 数据字典明细表实体类
 *
 * @author Tao.Chen
 * @date 2020-11-20 15:00:54
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_dict_data")
@CrmTable(name = "mdm_dict_data",tableNote = "数据字典明细表实体类")
public class MdmDictDataEntity extends CrmExtTenEntity<MdmDictDataEntity> {

    /**
     * 字典编码
     */
	@CrmColumn(name = "dict_code", length = 64)
    private String dictCode;

    /**
     * 字典名称
     */
	@CrmColumn(name = "dict_value", length = 255)
    private String dictValue;

    /**
     * 字典描述
     */
	@CrmColumn(name = "dict_desc", length = 255)
    private String dictDesc;

    /**
     * 字典类型编码
     */
	@CrmColumn(name = "dict_type_code", length = 64)
    private String dictTypeCode;

    /**
     * 排序
     */
	@CrmColumn(name = "dict_sort", length = 64)
    private Integer dictSort;

    /**
     * 上级编码
     */
	@CrmColumn(name = "parent_dict_code", length = 64)
    private String parentDictCode;

}
